/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import com.jurismarches.vradi.ui.admin.content.AdminClientUI;
import com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI;
import com.jurismarches.vradi.ui.admin.content.AdminGroupUI;
import com.jurismarches.vradi.ui.admin.content.AdminStatusUI;
import com.jurismarches.vradi.ui.admin.content.AdminUserUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import java.awt.Component;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.WikittyExtension;

public abstract class VradiNavigationTreeHelper
extends NavigationTreeHelper {
    private static final Log log = LogFactory.getLog(VradiNavigationTreeHelper.class);
    public static final JAXXContextEntryDef<List<Client>> CLIENTS = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminClient.categoryClient"));
    public static final JAXXContextEntryDef<List<User>> USERS = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminUser.categoryUser"));
    public static final JAXXContextEntryDef<List<Group>> GROUPS = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminGroup.categoryGroup"));
    public static final JAXXContextEntryDef<List<Status>> STATUSES = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminStatus.categoryStatus"));
    public static final JAXXContextEntryDef<List<WikittyExtension>> FORMS = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminForm.categoryForm"));
    public static final JAXXContextEntryDef<List<XmlStream>> XMLSTREAMS = SwingUtil.newListContextEntryDef((String)I18n.n_((String)"vradi.adminXmlStream.categoryXmlStream"));
    protected static String NEW_CLIENT_NAME = I18n.n_((String)"vradi.adminClient.newClientName");
    protected static String NEW_GROUP_NAME = I18n.n_((String)"vradi.adminGroup.newGroupName");
    protected static String NEW_USER_NAME = I18n.n_((String)"vradi.adminUser.newUserName");
    protected static String NEW_STATUS_NAME = I18n.n_((String)"vradi.adminStatus.newStatusName");
    protected static String NEW_XMLSTREAM_NAME = I18n.n_((String)"vradi.adminXmlStream.newStreamName");
    protected final AdminTreeModelBuilder builder;

    protected abstract NavigationTreeModel createTreeModel();

    public VradiNavigationTreeHelper(String prefix, JAXXContext context) {
        super(prefix);
        this.builder = new AdminTreeModelBuilder(context);
    }

    public JAXXContext getContext() {
        return this.builder.getModel().getContext();
    }

    public NavigationTreeNode addClientToSelected(JAXXContext context, Client client) {
        return this.builder.addClient(context, this.getSelectedNode(context), client);
    }

    public NavigationTreeNode addFormTypeToSelected(JAXXContext context, WikittyExtension form) {
        return this.builder.addForm(context, this.getSelectedNode(context), form);
    }

    public NavigationTreeNode addGroupToSelected(JAXXContext context, Group group) {
        return this.builder.addGroup(context, this.getSelectedNode(context), group);
    }

    public NavigationTreeNode addStatusToSelected(JAXXContext context, Status status) {
        return this.builder.addStatus(context, this.getSelectedNode(context), status);
    }

    public NavigationTreeNode addUserToSelected(JAXXContext context, User user) {
        return this.builder.addUser(context, this.getSelectedNode(context), user);
    }

    public NavigationTreeNode addXmlStreamToSelected(JAXXContext context, XmlStream xml) {
        return this.builder.addXmlStream(context, this.getSelectedNode(context), xml);
    }

    public NavigationTreeNode addClient(JAXXContext context, NavigationTreeNode selectedNode, Client client) {
        return this.builder.addClient(context, selectedNode, client);
    }

    public NavigationTreeNode addStatus(JAXXContext context, NavigationTreeNode selectedNode, Status status) {
        return this.builder.addStatus(context, selectedNode, status);
    }

    public NavigationTreeNode addFormType(JAXXContext context, NavigationTreeNode selectedNode, WikittyExtension form) {
        return this.builder.addForm(context, selectedNode, form);
    }

    public NavigationTreeNode addGroup(JAXXContext context, NavigationTreeNode selectedNode, Group group) {
        return this.builder.addGroup(context, selectedNode, group);
    }

    public NavigationTreeNode addUser(JAXXContext context, NavigationTreeNode selectedNode, User user) {
        return this.builder.addUser(context, selectedNode, user);
    }

    public NavigationTreeNode addXmlStream(JAXXContext context, NavigationTreeNode selectedNode, XmlStream xml) {
        return this.builder.addXmlStream(context, selectedNode, xml);
    }

    public NavigationTreeNode getParentClientNode(NavigationTreeNode current) {
        return this.builder.getParentClientNode(current);
    }

    public NavigationTreeNode getParentGroupNode(NavigationTreeNode current) {
        return this.builder.getParentGroupNode(current);
    }

    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        return this.builder.removeChildNode(node);
    }

    public void reSelectNode(JAXXContext context, String fullPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to reselect " + fullPath));
        }
        NavigationTreeModel model = this.getSafeTreeModel(context);
        String[] paths = fullPath.split(model.getPathSeparator());
        Object node = model.getRoot();
        int max = paths.length;
        for (int i = 1; i < max; ++i) {
            NavigationTreeNode node2;
            String p = paths[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("find child with path " + p));
            }
            if ((node2 = node.getChild(p)) == null) break;
            node = node2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reselect " + node.getFullPath()));
        }
        if (node == model.getRoot()) {
            node = node.getChildCount() > 0 ? node.getChildAt(0) : null;
        }
        this.selectNode(context, (NavigationTreeNode)node);
    }

    public void reloadGroup(JAXXContext context, NavigationTreeNode groupNode, Group group) {
        groupNode.removeAllChildren();
        this.builder.fillGroupNode(group, groupNode);
    }

    public final NavigationTreeModel createTreeModel(JAXXContext context) {
        return this.createTreeModel();
    }

    public final NavigationTreeHandler createTreeHandler(JAXXObject context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"create handler");
        }
        NavigationTreeHandlerWithCardLayout handler = new NavigationTreeHandlerWithCardLayout(this.getPrefix(), context, NavigationTreeHandler.Strategy.PER_UI_TYPE){
            private static final long serialVersionUID = 1L;

            protected boolean closeUI(Component component) throws Exception {
                if (component != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing UI : " + component.getName()));
                    }
                    AdminContentUI content = (AdminContentUI)component;
                    return content.getHandler().answerToSave(content);
                }
                return true;
            }

            protected NavigationTreeModel getNavigationTreeModel() {
                return VradiNavigationTreeHelper.this.getSafeTreeModel((JAXXContext)this.getContext());
            }

            protected JPanel getContentContainer() {
                return this.getContext().getContent();
            }

            protected CardLayout2 getContentLayout() {
                return this.getContext().getContentLayout();
            }

            protected void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }

            public AdminNavUI getContext() {
                return (AdminNavUI)this.context;
            }
        };
        handler.setSelectionMode(1);
        this.setTreeHandler((JAXXContext)context, (NavigationTreeHandler)handler);
        this.setTree((JAXXContext)context, ((AdminNavUI)context).getNav());
        return handler;
    }

    protected class AdminTreeModelBuilder
    extends NavigationTreeModelBuilder {
        public AdminTreeModelBuilder(JAXXContext context) {
            super("/", context, null, null);
        }

        protected Decorator<?> getDecorator(Class<?> clazz) {
            return VradiContext.get().getDecorateurProvinder().getDecorator(clazz);
        }

        public NavigationTreeNode addClient(JAXXContext context, NavigationTreeNode node, Client client) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected node : " + node.getFullPath()));
            }
            if (client == null) {
                client = new ClientImpl();
                client.setName(I18n._((String)NEW_CLIENT_NAME));
                log.debug((Object)("Client id : " + client.getWikittyId()));
                NavigationTreeNode groupNode = this.getParentGroupNode(node);
                if (groupNode != null) {
                    Group group = (Group)groupNode.getBean();
                    group.addClient(client.getWikittyId());
                }
            }
            this.addIfNecessary((List)CLIENTS.getContextValue(context), client);
            return this.addClient(node, client.getWikittyId());
        }

        public NavigationTreeNode addClient(NavigationTreeNode node, String id) {
            NavigationTreeNode result = this.build(this.getClientCategoryNode(node), this.getDecorator(Client.class), "..[@wikittyId=\"" + id + "\"]", id, AdminClientUI.class, null);
            if (!this.isGroupNavigationTree(result)) {
                this.build(result, I18n._((String)USERS.getName()), USERS, "users", AdminUserUI.class, null);
            }
            return result;
        }

        public NavigationTreeNode addUser(JAXXContext context, NavigationTreeNode node, User user) {
            if (user == null) {
                user = new UserImpl();
                user.setName(I18n._((String)NEW_USER_NAME));
                NavigationTreeNode groupNode = this.getParentGroupNode(node);
                if (groupNode == null) {
                    NavigationTreeNode clientNode = this.getParentClientNode(node);
                    Client client = (Client)clientNode.getBean();
                    client.addUser(user.getWikittyId());
                } else {
                    Group group = (Group)groupNode.getBean();
                    group.addUser(user.getWikittyId());
                }
            }
            this.addIfNecessary((List)USERS.getContextValue(context), user);
            return this.addUser(node, user.getWikittyId());
        }

        public NavigationTreeNode addUser(NavigationTreeNode node, String id) {
            return this.build(this.getUserCategoryNode(node), this.getDecorator(User.class), "..[@wikittyId=\"" + id + "\"]", id, AdminUserUI.class, null);
        }

        public NavigationTreeNode addGroup(JAXXContext context, NavigationTreeNode node, Group group) {
            if (group == null) {
                group = new GroupImpl();
                group.setName(I18n._((String)NEW_GROUP_NAME));
            }
            this.addIfNecessary((List)GROUPS.getContextValue(context), group);
            return this.addGroup(node, group);
        }

        public NavigationTreeNode addGroup(NavigationTreeNode node, Group group) {
            NavigationTreeNode result = this.build(this.getGroupCategoryNode(node), this.getDecorator(Group.class), "..[@wikittyId=\"" + group.getWikittyId() + "\"]", group.getWikittyId(), AdminGroupUI.class, null);
            this.fillGroupNode(group, result);
            return result;
        }

        public void fillGroupNode(Group g, NavigationTreeNode groupNode) {
            Set clientsId;
            this.build(groupNode, I18n._((String)USERS.getName()), USERS, "users", AdminUserUI.class, null);
            this.build(groupNode, I18n._((String)CLIENTS.getName()), CLIENTS, "clients", AdminClientUI.class, null);
            Set usersId = g.getUser();
            if (usersId != null) {
                NavigationTreeNode usersNode = groupNode.getChildAt(0);
                for (String userId : usersId) {
                    log.debug((Object)("add user " + userId + " to group " + g.getName()));
                    this.addUser(usersNode, userId);
                }
            }
            if ((clientsId = g.getClient()) != null) {
                NavigationTreeNode clientsNode = groupNode.getChildAt(1);
                for (String clientId : clientsId) {
                    log.debug((Object)("add client " + clientId + " to group " + g.getName()));
                    this.addClient(clientsNode, clientId);
                }
            }
        }

        public NavigationTreeNode addStatus(JAXXContext context, NavigationTreeNode selectedNode, Status status) {
            if (status == null) {
                status = new StatusImpl();
                status.setName(I18n._((String)NEW_STATUS_NAME));
            }
            this.addIfNecessary((List)STATUSES.getContextValue(context), status);
            return this.addStatus(selectedNode, status.getWikittyId());
        }

        public NavigationTreeNode addStatus(NavigationTreeNode selectedNode, String id) {
            NavigationTreeNode result = this.build(this.getStatusCategoryNode(selectedNode), this.getDecorator(Status.class), "..[@wikittyId=\"" + id + "\"]", id, AdminStatusUI.class, null);
            return result;
        }

        public NavigationTreeNode addForm(JAXXContext context, NavigationTreeNode selectedNode, WikittyExtension form) {
            this.addIfNecessary((List)FORMS.getContextValue(context), form);
            if (form != null) {
                return this.addForm(selectedNode, form.getId());
            }
            return null;
        }

        public NavigationTreeNode addForm(NavigationTreeNode selectedNode, String id) {
            return this.build(this.getFormCategoryNode(selectedNode), this.getDecorator(WikittyExtension.class), "..[@id=\"" + id + "\"]", id, AdminFormTypeUI.class, null);
        }

        public NavigationTreeNode addXmlStream(JAXXContext context, NavigationTreeNode selectedNode, XmlStream xml) {
            if (xml == null) {
                xml = new XmlStreamImpl();
                xml.setName(I18n._((String)NEW_XMLSTREAM_NAME));
            }
            this.addIfNecessary((List)XMLSTREAMS.getContextValue(context), xml);
            return this.addXmlStream(selectedNode, xml.getWikittyId());
        }

        public NavigationTreeNode addXmlStream(NavigationTreeNode selectedNode, String id) {
            NavigationTreeNode result = this.build(this.getXmlStreamCategoryNode(selectedNode), this.getDecorator(XmlStream.class), "..[@wikittyId=\"" + id + "\"]", id, AdminXmlStreamUI.class, null);
            return result;
        }

        public NavigationTreeNode getParentClientNode(NavigationTreeNode current) {
            NavigationTreeNode node = VradiNavigationTreeHelper.this.getParentNode(current, Client.class);
            return node;
        }

        public NavigationTreeNode getParentGroupNode(NavigationTreeNode current) {
            NavigationTreeNode node = VradiNavigationTreeHelper.this.getParentNode(current, Group.class);
            return node;
        }

        protected NavigationTreeNode getCategoryNode(NavigationTreeNode current, String categoryName) {
            NavigationTreeNode result = this.getParentCategoryNode(current, categoryName);
            if (result == null) {
                result = this.getChildCategoryNode(current, categoryName);
            }
            if (log.isDebugEnabled()) {
                if (result != null) {
                    log.debug((Object)("Find category [" + categoryName + "] node " + result.getFullPath()));
                } else {
                    log.debug((Object)("Cant find category [" + categoryName + "] node"));
                }
            }
            return result;
        }

        protected NavigationTreeNode getChildCategoryNode(NavigationTreeNode current, String categoryName) {
            if (current.getNodePath().equals(categoryName)) {
                return current;
            }
            Enumeration e = current.children();
            if (e.hasMoreElements()) {
                NavigationTreeNode child = (NavigationTreeNode)e.nextElement();
                return child == null ? null : this.getChildCategoryNode(child, categoryName);
            }
            return null;
        }

        protected NavigationTreeNode getParentCategoryNode(NavigationTreeNode current, String categoryName) {
            if (current.getNodePath().equals(categoryName)) {
                return current;
            }
            return current.getParent() == null ? null : this.getCategoryNode(current.getParent(), categoryName);
        }

        protected NavigationTreeNode getClientCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "clients");
        }

        protected NavigationTreeNode getUserCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "users");
        }

        protected NavigationTreeNode getGroupCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "groups");
        }

        protected NavigationTreeNode getStatusCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "statuses");
        }

        protected NavigationTreeNode getFormCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "forms");
        }

        protected NavigationTreeNode getXmlStreamCategoryNode(NavigationTreeNode current) {
            return this.getCategoryNode(current, "xmlStreams");
        }

        protected boolean isGroupNavigationTree(NavigationTreeNode current) {
            return current.getFullPath().matches("^\\$root\\/groups\\/.*$");
        }

        protected <T> void addIfNecessary(List<T> contextValue, T o) {
            if (!contextValue.contains(o)) {
                contextValue.add(o);
            }
        }
    }
}

