/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public class BusinessEntityBean implements BusinessEntity {

    private static final long serialVersionUID = 1L;

    protected String id;
    protected String version;

    /**
     * Map is LinkedHashMap to maintains order like user want
     * key: extension name
     * value: extension definition
     */
    protected Map<String, WikittyExtension> extensions =
            new LinkedHashMap<String, WikittyExtension>();
    /**
     * key: field name prefixed by extension name (dot separator)
     * value: value of field
     */
    protected Map<String, Object> fieldValue = new HashMap<String, Object>();

    public String getWikittyId() {
        return id;
    }

    public String getWikittyVersion() {
        return version;
    }

    public void setWikittyVersion(String version) {
        this.version = version;
    }

    @Override
    public void addExtension(WikittyExtension extension) {
        extensions.put(extension.getName(), extension);
    }

    @Override
    public Collection<WikittyExtension> getExtensions() {
        return extensions.values();
    }


    public Collection<String> getExtensionNames() {
        Collection<String> result = extensions.keySet();
        return result;
    }

    public Collection<String> getExtensionFields(String ext) {
        WikittyExtension extension = extensions.get(ext);
        Collection<String> result = extension.getFieldNames();
        return result;
    }

    public Object getField(String ext, String fieldName) {
        String key = ext + "$" + fieldName;
        Object result = fieldValue.get(key);
        return result;
    }

    public void setField(String ext, String fieldName, Object value) {
        String key = ext + "$" + fieldName;
        fieldValue.put(key, value);
    }

    public FieldType getFieldType(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

	}
