/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.nuiton.i18n.I18nFileReader;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleScope;

public class I18nBundleEntry
implements Comparable<I18nBundleEntry> {
    protected URL path;
    protected Locale locale;
    protected I18nBundleScope scope;

    public I18nBundleEntry(URL path, Locale locale, I18nBundleScope scope) {
        this.path = path;
        this.locale = locale;
        this.scope = scope;
    }

    public URL getPath() {
        return this.path;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public I18nBundleScope getScope() {
        return this.scope;
    }

    public boolean matchLocale(Locale locale, I18nBundleScope scope) {
        if (this.locale == null) {
            return true;
        }
        if (locale == null) {
            return false;
        }
        return this.locale.equals(locale) || this.scope.ordinal() < scope.ordinal() && locale.getLanguage().equals(this.locale.getLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Properties resource) throws IOException {
        InputStream inputStream = null;
        StringBuilder sb = new StringBuilder();
        try {
            I18nFileReader fileReader = new I18nFileReader();
            inputStream = this.getPath().openStream();
            if (I18nBundle.log.isDebugEnabled()) {
                sb.append(this.getPath()).append("\n");
            }
            fileReader.load(inputStream, "ISO-8859-1");
            if (I18nBundle.log.isDebugEnabled()) {
                for (Map.Entry<Object, Object> entry : fileReader.entrySet()) {
                    sb.append("ISO-8859-1").append(" : ").append(entry).append("\n");
                }
            }
            for (Map.Entry<Object, Object> entry : fileReader.entrySet()) {
                String oldValue;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.trim().isEmpty() && (oldValue = (String)resource.get(key)) != null) continue;
                resource.put(key, value);
            }
            if (I18nBundle.log.isDebugEnabled()) {
                sb.append("nbSentences : ").append(fileReader.size()).append("\n");
                sb.append("=====================================");
            }
            fileReader.clear();
        }
        finally {
            if (I18nBundle.log.isDebugEnabled()) {
                I18nBundle.log.debug((Object)sb.toString());
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public int compareTo(I18nBundleEntry o) {
        int i = this.getScope().compareTo(o.getScope());
        if (i == 0) {
            i = this.getLocale().toString().compareTo(o.getLocale().toString());
        }
        return i;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof I18nBundleEntry && this.path.equals(((I18nBundleEntry)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        String s = super.toString();
        return "<" + s.substring(s.lastIndexOf(".") + 1) + ", locale:" + this.locale + ", scope " + (Object)((Object)this.scope) + ", path:" + this.path + ">";
    }
}

