/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.editors;

import com.jurismarches.vradi.ui.UIHelper;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JListCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JListCellEditor.class);
    protected JList list;
    protected TableCellEditor delegate;

    public JListCellEditor(TableCellEditor delegate) {
        this.delegate = delegate;
        this.list = new JList(new DefaultListModel());
        this.list.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public JListCellEditor() {
        this(new DefaultCellEditor(new JTextField()));
    }

    public void updateUniverse(List<String> values) {
        UIHelper.fillList((JList)this.list, values, null);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        boolean b = super.isCellEditable(e);
        b &= ((Component)e.getSource()).hasFocus();
        if (e instanceof MouseEvent) {
            return b && ((MouseEvent)e).getClickCount() > 1;
        }
        return b;
    }

    @Override
    public Object getCellEditorValue() {
        Object[] values = this.list.getSelectedValues();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected values = " + Arrays.toString(values)));
        }
        return values;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor value" + value));
        }
        UIHelper.updateListSelection(this.list, value);
        this.list.setFont(table.getFont());
        return this.list;
    }
}

