/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class OfferListTableModel
extends AbstractTableModel {
    private static Log log = LogFactory.getLog(OfferListTableModel.class);
    protected List<Form> datas;
    protected Map<String, TreeNode> thesaurus;
    protected List<String> columnNames = new ArrayList<String>();

    public OfferListTableModel(List<Form> datas) {
        this.columnNames.add(I18n.n_((String)"vradi.offer.name"));
        this.columnNames.add(I18n.n_((String)"vradi.offerEdit.datePub"));
        this.columnNames.add(I18n.n_((String)"vradi.offer.statut"));
        this.thesaurus = new HashMap<String, TreeNode>();
        List<String> columnsThesaurusId = VradiHelper.getVradiListColumns();
        for (String id : columnsThesaurusId) {
            try {
                TreeNode t = ServiceHelper.getVradiStorageService().getThesaurus(id);
                if (t != null) {
                    this.thesaurus.put(t.getName(), t);
                    this.columnNames.add(t.getName());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Adding Thesaurus name : " + t.getName()));
                    continue;
                }
                log.error((Object)("Cant get thesaurus : " + id));
            }
            catch (TechnicalException e) {
                log.error((Object)("Cant get thesaurus : " + id), (Throwable)e);
                ErrorDialogUI.showError((Exception)e);
            }
        }
        this.datas = datas != null ? datas : new ArrayList();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        if (col > 0) {
            return this.columnNames.get(col);
        }
        return "";
    }

    @Override
    public int getRowCount() {
        int count = this.datas.size();
        return count;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.datas.size() && this.datas.get(row) != null) {
            if (col < 3) {
                if (col == 0) {
                    return this.datas.get(row).getName();
                }
                if (col == 1) {
                    return DateFormat.getDateInstance(3, Locale.FRANCE).format(this.datas.get(row).getDatePub());
                }
                if (col == 2) {
                    return this.datas.get(row).getStatut();
                }
            } else {
                Set<String> thesaurusIdOfBean = this.datas.get(row).getThesaurus();
                String result = "";
                if (thesaurusIdOfBean != null) {
                    String name = this.columnNames.get(col);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Want thesaurus name : " + name));
                    }
                    TreeNode thesaurusOfColumns = this.thesaurus.get(name);
                    for (String idOfBean : thesaurusIdOfBean) {
                        Set children = thesaurusOfColumns.getChildren();
                        if (children == null || !children.contains(idOfBean)) continue;
                        TreeNode thesaurusToDisplay = null;
                        try {
                            thesaurusToDisplay = ServiceHelper.getVradiStorageService().getThesaurus(idOfBean);
                        }
                        catch (TechnicalException e) {
                            log.error((Object)("cant get thesaurus : " + idOfBean), (Throwable)e);
                        }
                        if (thesaurusToDisplay == null) continue;
                        result = result + thesaurusToDisplay.getName() + ", ";
                    }
                    if (result.length() > 0) {
                        result = result.substring(0, result.length() - 2);
                    }
                }
                return result;
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) == null ? null : this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public List<Form> getDatas() {
        return this.datas;
    }

    public void setDatas(List<Form> datas) {
        this.datas = datas != null ? datas : new ArrayList();
        this.fireTableDataChanged();
    }

    public TreeNode getThesaurusByName(String name) {
        return this.thesaurus.get(name);
    }
}

