/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.VradiI18nTableCellRenderer;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class VradiHelper {
    private static final Log log = LogFactory.getLog(VradiHelper.class);
    public static String QUERIES = "vradi.queries";
    public static String XML_STREAMS = "vradi.xmlStreams";
    public static String CRITERIAS = "vradi.criterias";
    public static String THESAURUS = "vradi.thesaurus";
    public static String COLUMNS = "vradi.columns";
    public static Properties userProperties = null;
    public static Properties querryProperties = null;

    public static VradiConfig getVradiConfig() {
        return VradiContext.get().getVradiConfig();
    }

    protected static Properties getUserProperties() {
        if (userProperties == null) {
            userProperties = VradiHelper.getProperties(VradiHelper.getVradiConfig().getUserFile());
        }
        return userProperties;
    }

    protected static Properties getProperties(File propertyFile) {
        Properties properties;
        try {
            properties = new Properties();
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            FileInputStream input = new FileInputStream(propertyFile);
            properties.load(input);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not get " + propertyFile.getName() + " caused by : " + ioe.getMessage(), ioe);
        }
        return properties;
    }

    protected static Properties store(Properties property, File file) {
        try {
            OutputStreamWriter fileOutputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1");
            property.store(fileOutputStream, "");
        }
        catch (IOException e) {
            log.error((Object)"Cant save request property caused by : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        return property;
    }

    protected static void storeUserProperties(Properties properties) {
        File userFile = VradiHelper.getVradiConfig().getUserFile();
        VradiHelper.store(properties, userFile);
    }

    protected static List<String> getUserListOfStringFromProperties(String propertyName) {
        Properties properties = VradiHelper.getUserProperties();
        ArrayList<String> result = new ArrayList<String>();
        String resultNames = properties.getProperty(propertyName);
        if (resultNames != null) {
            for (String resultName : resultNames.split(",")) {
                String utf8ResultName = null;
                try {
                    utf8ResultName = new String(resultName.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException eee) {
                    utf8ResultName = resultName;
                }
                result.add(utf8ResultName);
            }
        } else {
            log.warn((Object)("Cant find property : " + propertyName));
        }
        return result;
    }

    protected static void storeUserListProperties(String propertyName, List<String> values) {
        Properties properties = VradiHelper.getUserProperties();
        StringBuffer store = new StringBuffer();
        for (String value : values) {
            store.append(value).append(",");
        }
        int length = store.length() - 1;
        if (length > 0) {
            store.deleteCharAt(length);
        }
        properties.setProperty(propertyName, store.toString());
        VradiHelper.storeUserProperties(properties);
    }

    protected static void addToUserListProperties(String propertyName, String value) {
        VradiHelper.addToUserListProperties(propertyName, value, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace) {
        VradiHelper.addToUserListProperties(propertyName, value, replace, false, false);
    }

    protected static void addToUserListProperties(String propertyName, String value, boolean replace, boolean inverse, boolean uniqueValues) {
        ArrayList<String> result;
        List<Object> list = result = replace ? new ArrayList() : VradiHelper.getUserListOfStringFromProperties(propertyName);
        if (value != null) {
            String isoValue;
            try {
                isoValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException eee) {
                isoValue = value;
            }
            if (uniqueValues && result.contains(isoValue)) {
                result.remove(isoValue);
                if (inverse) {
                    result.add(0, isoValue);
                } else {
                    result.add(isoValue);
                }
            } else if (inverse) {
                result.add(0, isoValue);
            } else {
                result.add(isoValue);
            }
        }
        VradiHelper.storeUserListProperties(propertyName, result);
    }

    protected static List<String> removeToUserListProperties(String propertyName, String value) {
        Properties properties = VradiHelper.getUserProperties();
        List<String> result = VradiHelper.getUserListOfStringFromProperties(propertyName);
        result.remove(value);
        VradiHelper.storeUserListProperties(propertyName, result);
        return result;
    }

    public static void addRequestToProperties(String request) {
        VradiHelper.addToUserListProperties(QUERIES, request, false, true, true);
    }

    public static List<String> loadRequests() {
        return VradiHelper.getUserListOfStringFromProperties(QUERIES);
    }

    public static void setLastItemOfXmlStream(String xmlStreamName, String value) {
        VradiHelper.addToUserListProperties(XML_STREAMS + "." + xmlStreamName, value, true);
    }

    public static String getLastItemOfXmlStream(String xmlStreamName) {
        List<String> prop = VradiHelper.getUserListOfStringFromProperties(XML_STREAMS + "." + xmlStreamName);
        if (!prop.isEmpty()) {
            return prop.get(0);
        }
        return null;
    }

    public static List<String> getVradiListCriteria() {
        return VradiHelper.getUserListOfStringFromProperties(CRITERIAS);
    }

    public static void removeVradiListCriteria(TreeNode value) {
        VradiHelper.removeToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static void addVradiListCriteria(TreeNode value) {
        VradiHelper.addToUserListProperties(CRITERIAS, value.getWikittyId());
    }

    public static List<String> getVradiListThesaurus() {
        return VradiHelper.getUserListOfStringFromProperties(THESAURUS);
    }

    public static void removeVradiListThesaurus(TreeNode value) {
        VradiHelper.removeToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static void addVradiListThesaurus(TreeNode value) {
        VradiHelper.addToUserListProperties(THESAURUS, value.getWikittyId());
    }

    public static List<String> getVradiListColumns() {
        return VradiHelper.getUserListOfStringFromProperties(COLUMNS);
    }

    public static void removeVradiListColumns(TreeNode value) {
        VradiHelper.removeToUserListProperties(COLUMNS, value.getWikittyId());
    }

    public static void addVradiListColumns(TreeNode value) {
        VradiHelper.addToUserListProperties(COLUMNS, value.getWikittyId());
    }

    public static String getEntityName(Object o) {
        return VradiHelper.getStringValue(o, "name");
    }

    public static String getStringValue(Object o, String method) {
        try {
            if (o == null) {
                return "";
            }
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)o, (String)method);
            if (descriptor == null) {
                return "";
            }
            Method getter = descriptor.getReadMethod();
            Object invoke = getter.invoke(o, new Object[0]);
            if (invoke == null) {
                return "";
            }
            String result = (String)invoke;
            return result;
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)ex);
        }
        catch (SecurityException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)ex);
        }
        catch (IllegalAccessException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)ex);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)ex);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)ex);
            ErrorDialogUI.showError((Exception)ex);
        }
        return "";
    }

    public static FieldTypeEnum getFieldTypeEnum(FieldType type) {
        for (FieldTypeEnum typeEnum : FieldTypeEnum.values()) {
            if (!typeEnum.isType(type)) continue;
            return typeEnum;
        }
        return null;
    }

    public static ComboBoxModel getFormTypesModel() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(VradiHelper.getFormTypes());
        return model;
    }

    public static Object[] getFormTypes() {
        VradiStorageService vradiStorageService = ServiceHelper.getVradiStorageService();
        List formTypes = new ArrayList();
        try {
            formTypes = vradiStorageService.getAllFormTypes();
        }
        catch (TechnicalException eee) {
            ErrorDialogUI.showError((Exception)eee);
            log.error((Object)("Cant get form type : " + eee));
        }
        Object[] result = new Object[formTypes.size() + 1];
        result[0] = null;
        for (int i = 0; i < formTypes.size(); ++i) {
            result[i + 1] = formTypes.get(i);
        }
        return result;
    }

    public static Date getLastDayDate() {
        Date result = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        cal.roll(5, false);
        return cal.getTime();
    }

    public static Date getBeginMonthDate() {
        Date result = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static void getThesaurusChildren(Thesaurus th, List<String> thesaurusIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get child from parent : " + th.getName()));
        }
        for (Thesaurus child : th.getChildren()) {
            if (thesaurusIds.contains(child.getWikittyId())) continue;
            thesaurusIds.add(child.getWikittyId());
            VradiHelper.getThesaurusChildren(child, thesaurusIds);
        }
    }

    public static List<Form> executeQuery(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List<String>[] thesaurus) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)query);
            }
            List result = ServiceHelper.getVradiStorageService().findForms(query, extension, dateType, beginDate, endDate, (List[])thesaurus);
            if (log.isDebugEnabled()) {
                log.debug((Object)result.size());
            }
            if (log.isDebugEnabled()) {
                for (Form form : result) {
                    log.debug((Object)form.getName());
                }
            }
            return result;
        }
        catch (TechnicalException eee) {
            log.error((Object)"Cant execute query : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
            return null;
        }
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles)));
    }
}

