/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.logging.Level;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.update.processor.LogUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class LogUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    int maxNumToLog = 8;

    public void init(NamedList args) {
        if (args != null) {
            SolrParams params = SolrParams.toSolrParams((NamedList)args);
            this.maxNumToLog = params.getInt("maxNumToLog", this.maxNumToLog);
        }
    }

    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        boolean doLog = LogUpdateProcessor.log.isLoggable(Level.INFO);
        if (doLog) {
            return new LogUpdateProcessor(req, rsp, this, next);
        }
        return null;
    }
}

