/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LogLevelSelection
extends HttpServlet {
    private static Level[] LEVELS = new Level[]{null, Level.FINEST, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.write("<html><head>\n");
        out.write("<title>Solr Admin: JDK Log Level Selector</title>\n");
        out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"solr-admin.css\" />");
        out.write("</head><body>\n");
        out.write("<a href=\".\"><img border=\"0\" align=\"right\" height=\"61\" width=\"142\" src=\"solr-head.gif\" alt=\"Solr\"></a>");
        out.write("<h1>JDK Log Level Selector</h1>");
        out.write("<p>Below is the complete JDK Log hierarchy with intermediate logger/categories synthesized.  The effective logging level is shown to the far right. If a logger has unset level, then the effective level is that of the nearest ancestor with a level setting.  Note that this only shows JDK Log levels.</p>\n");
        out.write("<form action='");
        out.write(request.getRequestURI());
        out.write("' method='POST'>\n");
        out.write("<input type='submit' name='submit' value='set' class='button'>\n");
        out.write("<input type='submit' name='submit' value='cancel' class='button'>\n");
        out.write("<br><br>\n");
        out.write("<table cellspacing='2' cellpadding='2'>");
        out.write("<tr bgcolor='#CCCCFF'><th align=left>Logger/Category name<br><th colspan=9>Level</th></tr><tr bgcolor='#CCCCFF'><td bgcolor='#AAAAAA'>(Dark rows don't yet exist.)</td>");
        for (int j = 0; j < LEVELS.length; ++j) {
            out.write("<th align=left>");
            if (LEVELS[j] != null) {
                out.write(LEVELS[j].toString());
            } else {
                out.write("unset");
            }
            out.write("</th>");
        }
        out.write("<th align=left>Effective</th>\n");
        out.write("</tr>\n");
        for (LogWrapper wrapper : this.buildWrappers()) {
            out.write("<tr");
            if (wrapper.logger == null) {
                out.write(" bgcolor='#AAAAAA'");
            }
            out.write("><td>");
            if ("".equals(wrapper.name)) {
                out.write("root");
            } else {
                out.write(wrapper.name);
            }
            out.write("</td>\n");
            for (int j = 0; j < LEVELS.length; ++j) {
                out.write("<td align=center>");
                if (!wrapper.name.equals("root") || LEVELS[j] != null) {
                    out.write("<input type='radio' name='");
                    if ("".equals(wrapper.name)) {
                        out.write("root");
                    } else {
                        out.write(wrapper.name);
                    }
                    out.write("' value='");
                    if (LEVELS[j] != null) {
                        out.write(LEVELS[j].toString());
                    } else {
                        out.write("unset");
                    }
                    out.write(39);
                    if (LEVELS[j] == wrapper.level()) {
                        out.write(" checked");
                    }
                    out.write(62);
                }
                out.write("</td>\n");
            }
            out.write("<td align=center>");
            if (wrapper.logger != null) {
                out.write(this.getEffectiveLevel(wrapper.logger).toString());
            }
            out.write("</td></tr>\n");
        }
        out.write("</table>\n");
        out.write("<br>\n");
        out.write("<input type='submit' name='submit' value='set' class='button'>\n");
        out.write("<input type='submit' name='submit' value='cancel' class='button'>\n");
        out.write("</form>\n");
        out.write("</body></html>\n");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getParameter("submit").equals("set")) {
            Map paramMap = request.getParameterMap();
            for (Map.Entry p : paramMap.entrySet()) {
                String name = (String)p.getKey();
                String value = ((String[])p.getValue())[0];
                if (name.equals("submit")) continue;
                LogManager logManager = LogManager.getLogManager();
                Logger logger = "root".equals(name) ? logManager.getLogger("") : logManager.getLogger(name);
                if ("unset".equals(value)) {
                    if (logger == null || logger.getLevel() == null) continue;
                    logger.setLevel(null);
                    this.log.info("Unset log level on '" + name + "'.");
                    continue;
                }
                Level level = Level.parse(value);
                if (logger == null) {
                    logger = Logger.getLogger(name);
                }
                if (logger.getLevel() == level) continue;
                logger.setLevel(level);
                this.log.info("Set '" + name + "' to " + level + " level.");
            }
        } else {
            this.log.fine("Selection form cancelled");
        }
        response.sendRedirect(request.getRequestURI());
    }

    private Collection buildWrappers() {
        TreeSet<LogWrapper> roots = new TreeSet<LogWrapper>();
        roots.add(LogWrapper.ROOT);
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> loggerNames = logManager.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            int dot;
            String name = loggerNames.nextElement();
            Logger logger = Logger.getLogger(name);
            LogWrapper wrapper = new LogWrapper(logger);
            roots.remove(wrapper);
            roots.add(wrapper);
            while ((dot = name.lastIndexOf(".")) >= 0) {
                name = name.substring(0, dot);
                roots.add(new LogWrapper(name));
            }
        }
        return roots;
    }

    private Level getEffectiveLevel(Logger logger) {
        Level level = logger.getLevel();
        if (level != null) {
            return level;
        }
        for (Level l : LEVELS) {
            if (l == null || !logger.isLoggable(l)) continue;
            level = l;
        }
        return level != null ? level : Level.OFF;
    }

    private static class LogWrapper
    implements Comparable {
        public static LogWrapper ROOT = new LogWrapper(LogManager.getLogManager().getLogger(""));
        public Logger logger = null;
        public String name;

        public LogWrapper(Logger logger) {
            this.logger = logger;
            this.name = logger.getName();
        }

        public LogWrapper(String name) {
            this.name = name;
        }

        public int compareTo(Object other) {
            if (this.equals(other)) {
                return 0;
            }
            if (this == ROOT) {
                return -1;
            }
            if (other == ROOT) {
                return 1;
            }
            return this.name.compareTo(((LogWrapper)other).name);
        }

        public boolean equals(Object other) {
            return this.name.equals(((LogWrapper)other).name);
        }

        public Level level() {
            if (this.logger != null) {
                return this.logger.getLevel();
            }
            return null;
        }
    }
}

