/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.ConstantScorePrefixQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.WildcardFilter;

public class SolrQueryParser
extends QueryParser {
    protected final IndexSchema schema;
    protected final QParser parser;
    protected final String defaultField;

    public SolrQueryParser(IndexSchema schema, String defaultField) {
        super(defaultField == null ? schema.getDefaultSearchFieldName() : defaultField, schema.getQueryAnalyzer());
        this.schema = schema;
        this.parser = null;
        this.defaultField = defaultField;
        this.setLowercaseExpandedTerms(false);
    }

    public SolrQueryParser(QParser parser, String defaultField) {
        this(parser, defaultField, parser.getReq().getSchema().getQueryAnalyzer());
    }

    public SolrQueryParser(QParser parser, String defaultField, Analyzer analyzer) {
        super(defaultField, analyzer);
        this.schema = parser.getReq().getSchema();
        this.parser = parser;
        this.defaultField = defaultField;
        this.setLowercaseExpandedTerms(false);
    }

    private void checkNullField(String field) throws SolrException {
        if (field == null && this.defaultField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no field name specified in query and no defaultSearchField defined in schema.xml");
        }
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        this.checkNullField(field);
        if (field.charAt(0) == '_') {
            if ("_val_".equals(field)) {
                if (this.parser == null) {
                    return QueryParsing.parseFunction(queryText, this.schema);
                }
                QParser nested = this.parser.subQuery(queryText, "func");
                return nested.getQuery();
            }
            if ("_query_".equals(field) && this.parser != null) {
                return this.parser.subQuery(queryText, null).getQuery();
            }
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        this.checkNullField(field);
        FieldType ft = this.schema.getFieldType(field);
        return new ConstantScoreRangeQuery(field, "*".equals(part1) ? null : ft.toInternal(part1), "*".equals(part2) ? null : ft.toInternal(part2), inclusive, inclusive);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        this.checkNullField(field);
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new ConstantScorePrefixQuery(t);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        Query q = super.getWildcardQuery(field, termStr);
        if (q instanceof WildcardQuery) {
            return new ConstantScoreQuery((Filter)new WildcardFilter(((WildcardQuery)q).getTerm()));
        }
        return q;
    }
}

