/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.LucenePackage;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfoHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("core", SystemInfoHandler.getCoreInfo(req.getCore()));
        rsp.add("lucene", SystemInfoHandler.getLuceneInfo());
        rsp.add("jvm", SystemInfoHandler.getJvmInfo());
        rsp.add("system", SystemInfoHandler.getSystemInfo());
    }

    private static SimpleOrderedMap<Object> getCoreInfo(SolrCore core) throws Exception {
        SimpleOrderedMap info = new SimpleOrderedMap();
        IndexSchema schema = core.getSchema();
        info.add("schema", (Object)(schema != null ? schema.getName() : "no schema!"));
        InetAddress addr = InetAddress.getLocalHost();
        info.add("host", (Object)addr.getCanonicalHostName());
        info.add("now", (Object)new Date());
        info.add("start", (Object)new Date(core.getStartTime()));
        SimpleOrderedMap dirs = new SimpleOrderedMap();
        dirs.add("instance", (Object)new File(core.getResourceLoader().getInstanceDir()).getAbsolutePath());
        dirs.add("data", (Object)new File(core.getDataDir()).getAbsolutePath());
        dirs.add("index", (Object)new File(core.getIndexDir()).getAbsolutePath());
        info.add("directory", (Object)dirs);
        return info;
    }

    public static SimpleOrderedMap<Object> getSystemInfo() throws Exception {
        SimpleOrderedMap info = new SimpleOrderedMap();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.add("name", (Object)os.getName());
        info.add("version", (Object)os.getVersion());
        info.add("arch", (Object)os.getArch());
        SystemInfoHandler.addGetterIfAvaliable(os, "systemLoadAverage", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "openFileDescriptorCount", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "maxFileDescriptorCount", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "committedVirtualMemorySize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalPhysicalMemorySize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalSwapSpaceSize", (NamedList<Object>)info);
        SystemInfoHandler.addGetterIfAvaliable(os, "processCpuTime", (NamedList<Object>)info);
        try {
            if (!os.getName().toLowerCase().startsWith("windows")) {
                info.add("uname", (Object)SystemInfoHandler.execute("uname -a"));
                info.add("ulimit", (Object)SystemInfoHandler.execute("ulimit -n"));
                info.add("uptime", (Object)SystemInfoHandler.execute("uptime"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    static void addGetterIfAvaliable(Object obj, String getter, NamedList<Object> info) {
        try {
            String n = Character.toUpperCase(getter.charAt(0)) + getter.substring(1);
            Method m = obj.getClass().getMethod("get" + n, new Class[0]);
            Object v = m.invoke(obj, (Object[])null);
            if (v != null) {
                info.add(getter, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execute(String cmd) {
        String string;
        DataInputStream in = null;
        Reader reader = null;
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            in = new DataInputStream(process.getInputStream());
            string = IOUtils.toString((InputStream)in);
        }
        catch (Exception ex) {
            String string2;
            try {
                ex.printStackTrace();
                string2 = "(error executing: " + cmd + ")";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((InputStream)in);
            return string2;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public static SimpleOrderedMap<Object> getJvmInfo() {
        SimpleOrderedMap jvm = new SimpleOrderedMap();
        jvm.add("version", (Object)System.getProperty("java.vm.version"));
        jvm.add("name", (Object)System.getProperty("java.vm.name"));
        Runtime runtime = Runtime.getRuntime();
        jvm.add("processors", (Object)runtime.availableProcessors());
        long used = runtime.totalMemory() - runtime.freeMemory();
        int percentUsed = (int)((double)used / (double)runtime.maxMemory() * 100.0);
        SimpleOrderedMap mem = new SimpleOrderedMap();
        mem.add("free", (Object)FileUtils.byteCountToDisplaySize((long)runtime.freeMemory()));
        mem.add("total", (Object)FileUtils.byteCountToDisplaySize((long)runtime.totalMemory()));
        mem.add("max", (Object)FileUtils.byteCountToDisplaySize((long)runtime.maxMemory()));
        mem.add("used", (Object)(FileUtils.byteCountToDisplaySize((long)used) + " (%" + percentUsed + ")"));
        jvm.add("memory", (Object)mem);
        SimpleOrderedMap jmx = new SimpleOrderedMap();
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            jmx.add("bootclasspath", (Object)mx.getBootClassPath());
            jmx.add("classpath", (Object)mx.getClassPath());
            jmx.add("commandLineArgs", mx.getInputArguments());
            jmx.add("startTime", (Object)new Date(mx.getStartTime()));
            jmx.add("upTimeMS", (Object)mx.getUptime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jvm.add("jmx", (Object)jmx);
        return jvm;
    }

    private static SimpleOrderedMap<Object> getLuceneInfo() throws Exception {
        SimpleOrderedMap info = new SimpleOrderedMap();
        String solrImplVersion = "";
        String solrSpecVersion = "";
        String luceneImplVersion = "";
        String luceneSpecVersion = "";
        Package p = SolrCore.class.getPackage();
        StringWriter tmp = new StringWriter();
        solrImplVersion = p.getImplementationVersion();
        if (null != solrImplVersion) {
            XML.escapeCharData((String)solrImplVersion, (Writer)tmp);
            solrImplVersion = tmp.toString();
        }
        tmp = new StringWriter();
        solrSpecVersion = p.getSpecificationVersion();
        if (null != solrSpecVersion) {
            XML.escapeCharData((String)solrSpecVersion, (Writer)tmp);
            solrSpecVersion = tmp.toString();
        }
        p = LucenePackage.class.getPackage();
        tmp = new StringWriter();
        luceneImplVersion = p.getImplementationVersion();
        if (null != luceneImplVersion) {
            XML.escapeCharData((String)luceneImplVersion, (Writer)tmp);
            luceneImplVersion = tmp.toString();
        }
        tmp = new StringWriter();
        luceneSpecVersion = p.getSpecificationVersion();
        if (null != luceneSpecVersion) {
            XML.escapeCharData((String)luceneSpecVersion, (Writer)tmp);
            luceneSpecVersion = tmp.toString();
        }
        info.add("solr-spec-version", (Object)solrSpecVersion);
        info.add("solr-impl-version", (Object)solrImplVersion);
        info.add("lucene-spec-version", (Object)luceneSpecVersion);
        info.add("lucene-impl-version", (Object)luceneImplVersion);
        return info;
    }

    @Override
    public String getDescription() {
        return "Get System Info";
    }

    @Override
    public String getVersion() {
        return "$Revision: 690026 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: SystemInfoHandler.java 690026 2008-08-28 22:20:00Z yonik $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/admin/SystemInfoHandler.java $";
    }
}

