/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class NGramTokenizer
extends Tokenizer {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private int minGram;
    private int maxGram;
    private int gramSize;
    private int pos = 0;
    private int inLen;
    private String inStr;
    private boolean started = false;

    public NGramTokenizer(Reader input, int minGram, int maxGram) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    public NGramTokenizer(Reader input) {
        this(input, 1, 2);
    }

    public final Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        if (!this.started) {
            this.started = true;
            this.gramSize = this.minGram;
            char[] chars = new char[1024];
            this.input.read(chars);
            this.inStr = new String(chars).trim();
            this.inLen = this.inStr.length();
        }
        if (this.pos + this.gramSize > this.inLen) {
            this.pos = 0;
            ++this.gramSize;
            if (this.gramSize > this.maxGram) {
                return null;
            }
            if (this.pos + this.gramSize > this.inLen) {
                return null;
            }
        }
        int oldPos = this.pos++;
        return reusableToken.reinit(this.inStr, oldPos, this.gramSize, oldPos, oldPos + this.gramSize);
    }
}

