/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.EventListener;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nuiton.util.CategorisedListenerSet;

public class Log {
    private static Log LOG_INSTANCE = new Log();
    protected static CategorisedListenerSet<LogListener> listeners = new CategorisedListenerSet();
    public static final Level USER_INFO = new UserLevel("USERINFO", 600);

    public static void addLogListener(LogListener l) {
        listeners.add(LOG_INSTANCE, l);
    }

    public static void removeLogListener(LogListener l) {
        listeners.remove(LOG_INSTANCE, l);
    }

    public static void addLogListener(LogListener l, String category) {
        listeners.add(category, l);
    }

    public static void removeLogListener(LogListener l, String category) {
        listeners.remove(category, l);
    }

    protected static void fire(String category, Level level, String message, Throwable exception) {
        LogEvent e = new LogEvent(null, category, level, message, exception);
        try {
            Log.logDevFinest("org.nuiton.util.Log.fire", "Category: " + category + " listeners enregistr\u00e9s: " + listeners);
            listeners.fire(category, "logMessage", e);
            listeners.fire(LOG_INSTANCE, "logMessage", e);
        }
        catch (Exception eee) {
            Logger.getLogger(Log.class.getName() + ".fire").log(Level.WARNING, "Error during send log event", eee);
        }
    }

    protected static void fire(String category, String message, int max, int value) {
        LogEvent e = new LogEvent(null, category, message, max, value);
        try {
            Log.log("org.nuiton.util.Log.fire", Level.FINEST, "Category: " + category + " listeners enregistr\u00e9s: " + listeners, null);
            listeners.fire(category, "logTask", e);
            listeners.fire(LOG_INSTANCE, "logTask", e);
        }
        catch (Exception eee) {
            Logger.getLogger(Log.class.getName() + ".fire").log(Level.WARNING, "Error during send log event", eee);
        }
    }

    public static void logUserInfo(String category, String message) {
        Log.logUserInfo(category, message, null);
    }

    public static void logUserInfo(String category, String message, Throwable e) {
        Log.log(category, USER_INFO, message, e);
        Log.fire(category, USER_INFO, message, e);
    }

    public static void logTask(String category, String message, int max, int current) {
        Log.log(category, USER_INFO, "task: " + message + "[" + current + "/" + max + "]", null);
        Log.fire(category, message, max, current);
    }

    public static void log(String category, Level level, String message, Throwable e) {
        if (e == null) {
            Logger.getLogger(category).log(level, message);
        } else {
            Logger.getLogger(category).log(level, message, e);
        }
    }

    public static void logDevFinest(String category, String message) {
        Log.logDevFinest(category, message, null);
    }

    public static void logDevFinest(String category, String message, Throwable e) {
        Log.log(category, Level.FINEST, message, e);
    }

    public static void logDevFiner(String category, String message) {
        Log.logDevFiner(category, message, null);
    }

    public static void logDevFiner(String category, String message, Throwable e) {
        Log.log(category, Level.FINER, message, e);
    }

    public static void logDevFine(String category, String message) {
        Log.logDevFine(category, message, null);
    }

    public static void logDevFine(String category, String message, Throwable e) {
        Log.log(category, Level.FINE, message, e);
    }

    public static void logDevInfo(String category, String message) {
        Log.logDevInfo(category, message, null);
    }

    public static void logDevInfo(String category, String message, Throwable e) {
        Log.log(category, Level.INFO, message, e);
    }

    public static void logDevWarn(String category, String message) {
        Log.logDevInfo(category, message, null);
    }

    public static void logDevWarn(String category, String message, Throwable e) {
        Log.log(category, Level.WARNING, message, e);
    }

    public static void logDevSevere(String category, String message) {
        Log.logDevSevere(category, message, null);
    }

    public static void logDevSevere(String category, String message, Throwable e) {
        Log.log(category, Level.SEVERE, message, e);
    }

    private static class UserLevel
    extends Level {
        private static final long serialVersionUID = -9075227788352473733L;

        public UserLevel(String name, int value) {
            super(name, value);
        }
    }

    public static class LogEvent
    extends EventObject {
        private static final long serialVersionUID = 6597052732707368243L;
        protected String category;
        protected Level level;
        protected String message;
        protected Throwable exception;
        protected int taskMax = 0;
        protected int taskValue = 0;

        public LogEvent(Object source, String category, Level level, String message, Throwable exception) {
            super(source == null ? LOG_INSTANCE : source);
            this.category = category;
            this.level = level;
            this.message = message;
            this.exception = exception;
        }

        public LogEvent(Object source, String category, String message, int taskMax, int taskValue) {
            super(source == null ? LOG_INSTANCE : source);
            this.category = category;
            this.message = message;
            this.taskMax = taskMax;
            this.taskValue = taskValue;
        }

        public String getCategory() {
            return this.category;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getException() {
            return this.exception;
        }

        public int getTaskMax() {
            return this.taskMax;
        }

        public int getTaskValue() {
            return this.taskValue;
        }
    }

    public static interface LogListener
    extends EventListener {
        public void logMessage(LogEvent var1);

        public void logTask(LogEvent var1);
    }
}

