/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.log;

import java.awt.GraphicsEnvironment;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ListenerSet;

public class UserLog {
    private static Log log = LogFactory.getLog(UserLog.class);
    protected static ListenerSet<Object> listeners = new ListenerSet();
    protected static boolean graphicUI = true;

    public static void addListeners(ListenerSet<Object> l) {
        listeners.add(l);
    }

    public static void removeListeners(ListenerSet<Object> l) {
        listeners.remove(l);
    }

    public static void setGraphicUI(boolean graphicUI) {
        UserLog.graphicUI = graphicUI;
    }

    public static boolean isGraphicUI() {
        return graphicUI && !GraphicsEnvironment.isHeadless();
    }

    protected static void show(Level level, String msg, Throwable cause) {
        try {
            listeners.fire("setText", msg);
        }
        catch (Exception e) {
            log.warn((Object)"Can't call setText on listener", (Throwable)e);
        }
        if (UserLog.isGraphicUI()) {
            String title = level.name();
            int type = -1;
            switch (level) {
                case DEBUG: {
                    type = -1;
                    break;
                }
                case INFO: {
                    type = 1;
                    break;
                }
                case WARN: {
                    type = 2;
                    break;
                }
                case ERROR: 
                case FATAL: {
                    type = 0;
                }
            }
            JOptionPane.showMessageDialog(null, msg, title, type);
        }
    }

    public static void debug(String msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
        UserLog.show(Level.DEBUG, msg, null);
    }

    public static void debug(String msg, Throwable cause) {
        if (log.isDebugEnabled()) {
            log.debug((Object)msg, cause);
        }
        UserLog.show(Level.DEBUG, msg, cause);
    }

    public static void info(String msg) {
        log.info((Object)msg);
        UserLog.show(Level.INFO, msg, null);
    }

    public static void info(String msg, Throwable cause) {
        log.info((Object)msg, cause);
        UserLog.show(Level.INFO, msg, cause);
    }

    public static void warn(String msg) {
        log.warn((Object)msg);
        UserLog.show(Level.WARN, msg, null);
    }

    public static void warn(String msg, Throwable cause) {
        log.warn((Object)msg, cause);
        UserLog.show(Level.WARN, msg, cause);
    }

    public static void error(String msg) {
        log.error((Object)msg);
        UserLog.show(Level.ERROR, msg, null);
    }

    public static void error(String msg, Throwable cause) {
        log.error((Object)msg, cause);
        UserLog.show(Level.ERROR, msg, cause);
    }

    public static void fatal(String msg) {
        log.fatal((Object)msg);
        UserLog.show(Level.FATAL, msg, null);
    }

    public static void fatal(String msg, Throwable cause) {
        log.fatal((Object)msg, cause);
        UserLog.show(Level.FATAL, msg, cause);
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

