/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.log;

import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.nuiton.log.LutinLog;
import org.nuiton.log.LutinLogListener;
import org.nuiton.util.CategorisedListenerSet;

public class LutinLogFactory
extends LogFactory {
    private static LutinLogFactory instance = null;
    protected LogFactory parentFactory = null;
    protected CategorisedListenerSet<LutinLogListener> listeners = new CategorisedListenerSet();
    protected long DefaultActiveProgressMonitorTime = 0L;
    protected long DefaultTimeout = 0L;
    private Timer timer;

    public static LutinLogFactory getInstance() {
        if (instance == null) {
            LogFactory factory = LogFactory.getFactory();
            instance = factory instanceof LutinLogFactory ? (LutinLogFactory)factory : new LutinLogFactory();
        }
        return instance;
    }

    public static LutinLog getLutinLog(Class<?> clazz) {
        LutinLogFactory factory = LutinLogFactory.getInstance();
        LutinLog result = (LutinLog)factory.getInstance(clazz);
        return result;
    }

    public static LutinLog getLutinLog(String cat) {
        LutinLogFactory factory = LutinLogFactory.getInstance();
        LutinLog result = (LutinLog)factory.getInstance(cat);
        return result;
    }

    public long getDefaultActiveProgressMonitorTime() {
        return this.DefaultActiveProgressMonitorTime;
    }

    public void setDefaultActiveProgressMonitorTime(long defaultActiveProgressMonitorTime) {
        this.DefaultActiveProgressMonitorTime = defaultActiveProgressMonitorTime;
    }

    public long getDefaultTimeout() {
        return this.DefaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.DefaultTimeout = defaultTimeout;
    }

    public void addLutinLogListener(LutinLogListener l) {
        this.listeners.add((Object)this, l);
    }

    public void addLutinLogListener(LutinLog log, LutinLogListener l) {
        this.listeners.addCategory((Object)this, log);
        this.listeners.add(log, l);
    }

    public void removeLutinLogListener(LutinLogListener l) {
        this.listeners.remove((Object)this, l);
    }

    public void removeLutinLogListener(LutinLog log, LutinLogListener l) {
        this.listeners.remove(log, l);
    }

    protected LogFactory getParentFactory() {
        if (this.parentFactory == null) {
            this.parentFactory = new LogFactoryImpl();
        }
        return this.parentFactory;
    }

    public Object getAttribute(String arg0) {
        Object result = this.getParentFactory().getAttribute(arg0);
        return result;
    }

    public String[] getAttributeNames() {
        String[] result = this.getParentFactory().getAttributeNames();
        return result;
    }

    public Log getInstance(Class arg0) throws LogConfigurationException {
        Log log = this.getParentFactory().getInstance(arg0);
        LutinLog result = new LutinLog(this, log);
        this.listeners.addCategory((Object)this, result);
        return result;
    }

    public Log getInstance(String arg0) throws LogConfigurationException {
        Log log = this.getParentFactory().getInstance(arg0);
        LutinLog result = new LutinLog(this, log);
        this.listeners.addCategory((Object)this, result);
        return result;
    }

    public void release() {
        this.getParentFactory().release();
    }

    public void removeAttribute(String arg0) {
        this.getParentFactory().removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.getParentFactory().setAttribute(arg0, arg1);
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("LutinLogTimer", true);
        }
        return this.timer;
    }
}

