/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.log;

import java.awt.Component;
import java.awt.HeadlessException;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.nuiton.log.Log4JWrapper;
import org.nuiton.log.LutinLogEvent;
import org.nuiton.log.LutinLogFactory;
import org.nuiton.log.LutinLogListener;
import org.nuiton.log.LutinProgressEvent;
import org.nuiton.log.ProgressMonitorFrame;
import org.nuiton.log.ProgressState;

public class LutinLog
implements Log {
    private LutinLogFactory factory = null;
    private Log parent = null;
    private long activeProgressMonitorTime;
    private ProgressState progressState = ProgressState.end;
    private long timeout = 0L;
    private int min;
    private int max;
    private int value;
    private ProgressMonitorFrame progressMonitorFrame;
    private TimerTask activeProgressMonitorTask = new TimerTask(){

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                Component frame = LutinLog.this.getProgressMonitorFrame();
                if (frame != null) {
                    frame.setVisible(true);
                }
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    };
    private TimerTask timeoutTask = new TimerTask(){

        @Override
        public void run() {
            LutinLog.this.end();
        }
    };

    protected LutinLog(LutinLogFactory factory, Log parent) {
        this.factory = factory;
        this.parent = parent;
        this.activeProgressMonitorTime = factory.getDefaultActiveProgressMonitorTime();
        this.timeout = factory.getDefaultTimeout();
        this.getProgressMonitorFrame();
    }

    public String toString() {
        String result = "LutinLog min: " + this.getMin() + " value:" + this.getValue() + " max:" + this.getMax() + " timeout:" + this.getTimeout();
        return result;
    }

    public void addLutinLogListener(LutinLogListener l) {
        this.factory.addLutinLogListener(this, l);
    }

    public void removeLutinLogListener(LutinLogListener l) {
        this.factory.removeLutinLogListener(this, l);
    }

    protected void fireLogEvent(LutinLogEvent.LogType type, Object msg, Throwable eee) {
        block2: {
            LutinLogEvent e = new LutinLogEvent(this, type, String.valueOf(msg), eee);
            try {
                this.factory.listeners.fire(this, "logEvent", e);
            }
            catch (Exception eee1) {
                if (!this.parent.isDebugEnabled()) break block2;
                this.parent.debug((Object)"Can't fire event", (Throwable)eee1);
            }
        }
    }

    protected void fireProgressEvent(LutinProgressEvent.ProgressType type) {
        block2: {
            LutinProgressEvent e = new LutinProgressEvent(this, type);
            try {
                this.factory.listeners.fire(this, "progressEvent", e);
            }
            catch (Exception eee1) {
                if (!this.parent.isDebugEnabled()) break block2;
                this.parent.debug((Object)"Can't fire event", (Throwable)eee1);
            }
        }
    }

    public void setActivateProgressMonitorTime(long time) {
        this.activeProgressMonitorTime = time;
    }

    public void start() {
        this.progressState = ProgressState.start;
        this.value = -1;
        if (this.activeProgressMonitorTime > 0L) {
            this.factory.getTimer().schedule(this.activeProgressMonitorTask, this.activeProgressMonitorTime);
        }
        if (this.timeout > 0L) {
            this.factory.getTimer().schedule(this.timeoutTask, this.timeout);
        }
        this.fireProgressEvent(LutinProgressEvent.ProgressType.start);
    }

    protected Component getProgressMonitorFrame() {
        if (this.progressMonitorFrame == null) {
            try {
                this.progressMonitorFrame = new ProgressMonitorFrame(this, null);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        return this.progressMonitorFrame;
    }

    public boolean isAskStopTask() {
        boolean result = this.progressState == ProgressState.stopAsked;
        return result;
    }

    public void setAskStopTask(boolean v) {
        if (this.progressState != ProgressState.end) {
            if (v) {
                this.progressState = ProgressState.stopAsked;
                this.fireProgressEvent(LutinProgressEvent.ProgressType.askStop);
            } else {
                this.progressState = ProgressState.start;
                this.fireProgressEvent(LutinProgressEvent.ProgressType.cancelAskStop);
            }
        }
    }

    public void end() {
        this.progressState = ProgressState.end;
        this.activeProgressMonitorTask.cancel();
        this.timeoutTask.cancel();
        if (this.progressMonitorFrame != null) {
            this.progressMonitorFrame.setVisible(false);
        }
        this.fireProgressEvent(LutinProgressEvent.ProgressType.end);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long time) {
        this.timeout = time;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int value) {
        this.min = value;
        this.fireProgressEvent(LutinProgressEvent.ProgressType.min);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int value) {
        this.max = value;
        this.fireProgressEvent(LutinProgressEvent.ProgressType.max);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.fireProgressEvent(LutinProgressEvent.ProgressType.value);
    }

    public boolean isTraceEnabled() {
        boolean result = this.parent.isTraceEnabled();
        return result;
    }

    public boolean isDebugEnabled() {
        boolean result = this.parent.isDebugEnabled();
        return result;
    }

    public boolean isInfoEnabled() {
        boolean result = this.parent.isInfoEnabled();
        return result;
    }

    public boolean isWarnEnabled() {
        boolean result = this.parent.isWarnEnabled();
        return result;
    }

    public boolean isErrorEnabled() {
        boolean result = this.parent.isErrorEnabled();
        return result;
    }

    public boolean isFatalEnabled() {
        boolean result = this.parent.isFatalEnabled();
        return result;
    }

    public void user(Object msg) {
        this.user(msg, null);
    }

    public void user(Object msg, Throwable eee) {
        if (this.isInfoEnabled()) {
            if (this.parent instanceof Log4JLogger) {
                Log4JWrapper.info((Log4JLogger)this.parent, msg, eee);
            } else {
                this.parent.info(msg, eee);
            }
        }
        this.fireLogEvent(LutinLogEvent.LogType.user, msg, eee);
    }

    public void trace(Object msg) {
        this.trace(msg, null);
    }

    public void trace(Object msg, Throwable eee) {
        if (this.parent instanceof Log4JLogger) {
            Log4JWrapper.trace((Log4JLogger)this.parent, msg, eee);
        } else {
            this.parent.trace(msg, eee);
        }
        this.fireLogEvent(LutinLogEvent.LogType.trace, msg, eee);
    }

    public void debug(Object msg) {
        this.debug(msg, null);
    }

    public void debug(Object msg, Throwable eee) {
        if (this.parent instanceof Log4JLogger) {
            Log4JWrapper.debug((Log4JLogger)this.parent, msg, eee);
        } else {
            this.parent.debug(msg, eee);
        }
        this.fireLogEvent(LutinLogEvent.LogType.debug, msg, eee);
    }

    public void info(Object msg) {
        this.info(msg, null);
    }

    public void info(Object msg, Throwable eee) {
        if (this.parent instanceof Log4JLogger) {
            Log4JWrapper.info((Log4JLogger)this.parent, msg, eee);
        } else {
            this.parent.info(msg, eee);
        }
        this.fireLogEvent(LutinLogEvent.LogType.info, msg, eee);
    }

    public void warn(Object msg) {
        this.warn(msg, null);
    }

    public void warn(Object msg, Throwable eee) {
        if (this.parent instanceof Log4JLogger) {
            Log4JWrapper.warn((Log4JLogger)this.parent, msg, eee);
        } else {
            this.parent.warn(msg, eee);
        }
        this.fireLogEvent(LutinLogEvent.LogType.warn, msg, eee);
    }

    public void error(Object msg) {
        this.error(msg, null);
    }

    public void error(Object msg, Throwable eee) {
        if (this.parent instanceof Log4JLogger) {
            Log4JWrapper.error((Log4JLogger)this.parent, msg, eee);
        } else {
            this.parent.error(msg, eee);
        }
        this.fireLogEvent(LutinLogEvent.LogType.error, msg, eee);
    }

    public void fatal(Object msg) {
        this.fatal(msg, null);
    }

    public void fatal(Object msg, Throwable eee) {
        if (this.parent instanceof Log4JLogger) {
            Log4JWrapper.fatal((Log4JLogger)this.parent, msg, eee);
        } else {
            this.parent.fatal(msg, eee);
        }
        this.fireLogEvent(LutinLogEvent.LogType.fatal, msg, eee);
    }
}

