/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.Language;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleFactory;
import org.nuiton.util.ClassLoaderUtil;
import org.nuiton.util.Resource;
import org.nuiton.util.StringUtil;

public class I18nLoader {
    private static final Log log = LogFactory.getLog(I18nLoader.class);
    protected Language language;
    protected List<Language> languages;
    protected static URL[] urls;
    protected I18nBundle[] bundles;
    protected final Locale defaultLocale;
    protected final String uniqueBundleName;

    public I18nLoader(Locale defaultLocale) {
        this(defaultLocale, null);
    }

    public I18nLoader(Locale defaultLocale, String uniqueBundleName) {
        this.defaultLocale = defaultLocale;
        this.uniqueBundleName = uniqueBundleName;
    }

    public Language getLanguage() {
        return this.language;
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            this.languages = new ArrayList<Language>();
        }
        return this.languages;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public boolean isEmpty() {
        this.checkInit();
        boolean isEmpty = I18nBundleFactory.isEmpty((I18nBundle[])this.bundles);
        return isEmpty;
    }

    public Locale[] getLocales() {
        this.checkInit();
        Locale[] result = I18nBundleFactory.getLocales((I18nBundle[])this.bundles);
        return result;
    }

    public I18nBundle[] getBundles() {
        this.checkInit();
        return this.bundles;
    }

    public I18nBundle[] getBundles(Locale l) {
        this.checkInit();
        I18nBundle[] result = I18nBundleFactory.getBundles((Locale)l, (I18nBundle[])this.bundles);
        return result;
    }

    public I18nBundleEntry[] getBundleEntries() {
        this.checkInit();
        I18nBundleEntry[] result = I18nBundleFactory.getBundleEntries((I18nBundle[])this.bundles);
        return result;
    }

    public I18nBundleEntry[] getBundleEntries(Locale l) {
        this.checkInit();
        I18nBundleEntry[] result = I18nBundleFactory.getBundleEntries((Locale)l, (Locale)this.defaultLocale, (I18nBundle[])this.bundles);
        return result;
    }

    void init() {
        if (this.isInit()) {
            return;
        }
        if (urls == null || urls.length == 0) {
            if (this.uniqueBundleName != null && (urls = I18nBundleFactory.getURLs((String)this.uniqueBundleName)) == null) {
                log.warn((Object)("coudl not find uniqueBundleName i18n " + this.uniqueBundleName));
            }
            if (urls == null) {
                urls = I18nLoader.getURLs(Language.getLoader(), I18n.getExtraURL());
            }
        }
        long t0 = System.nanoTime();
        List bundleDetected = I18nBundleFactory.detectBundles((URL[])urls);
        this.bundles = bundleDetected.toArray(new I18nBundle[bundleDetected.size()]);
        log.info((Object)(bundleDetected.size() + " bundle(s) found, [" + this.getBundleEntries().length + " file(s)] in " + StringUtil.convertTime(System.nanoTime() - t0)));
    }

    synchronized void setLanguage(Locale locale) {
        Language result;
        this.init();
        if (log.isDebugEnabled()) {
            log.debug((Object)("locale: " + locale));
        }
        if ((result = this.getLanguage(locale)) == null) {
            result = this.addLanguage(locale);
        } else {
            log.debug((Object)("using cached language : " + result));
        }
        this.language = result;
        Locale.setDefault(locale);
    }

    void close() {
        if (this.languages != null) {
            log.info((Object)("nb languages loaded : " + this.languages.size()));
            for (Language l : this.languages) {
                l.close();
            }
            this.languages.clear();
            this.languages = null;
        }
        if (urls != null) {
            urls = null;
        }
        if (this.bundles != null) {
            this.bundles = null;
        }
        this.language = null;
    }

    Language getLanguage(Locale locale) {
        if (this.languages != null && !this.languages.isEmpty()) {
            for (Language l : this.languages) {
                if (!locale.equals(l.getLocale())) continue;
                return l;
            }
        }
        return null;
    }

    Language addLanguage(Locale locale) {
        Language result = new Language(locale);
        long t0 = System.nanoTime();
        I18nBundleEntry[] entries = this.getBundleEntries(locale);
        result.load(entries);
        log.info((Object)(result + ", nbEntries: " + entries.length + ", nbSentences: " + result.size() + " in " + StringUtil.convertTime(System.nanoTime() - t0)));
        this.getLanguages().add(result);
        return result;
    }

    boolean isInit() {
        return this.bundles != null;
    }

    void checkInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("should call init method on " + I18nLoader.class);
        }
    }

    public static URL[] getURLs(URLClassLoader loader) {
        try {
            ArrayList<URL> urlToSeek = new ArrayList<URL>();
            urlToSeek.addAll(Arrays.asList(ClassLoaderUtil.getDeepURLs(loader)));
            int size = urlToSeek.size();
            Iterator it = urlToSeek.iterator();
            while (it.hasNext()) {
                URL url = (URL)it.next();
                if (Resource.containsDirectDirectory(url, "i18n")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("skip url with no i18n directory : " + url));
                }
                it.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("detect " + urlToSeek.size() + " i18n capable url (out of " + size + ")"));
            }
            List<URL> result = Resource.getURLs(".*i18n/.+\\.properties", urlToSeek.toArray(new URL[urlToSeek.size()]));
            if (log.isDebugEnabled()) {
                for (URL url : result) {
                    log.debug((Object)url.toString());
                }
            }
            return result.toArray(new URL[result.size()]);
        }
        catch (Exception eee) {
            log.warn((Object)("Unable to find urls for loader : " + loader + " for reason " + eee.getMessage()), (Throwable)eee);
            return new URL[0];
        }
    }

    public static URL[] getURLs(URLClassLoader loader, URL ... extraUrl) {
        try {
            ArrayList<URL> urlToSeek = new ArrayList<URL>();
            urlToSeek.addAll(Arrays.asList(ClassLoaderUtil.getDeepURLs(loader)));
            if (extraUrl.length > 0) {
                urlToSeek.addAll(Arrays.asList(extraUrl));
            }
            int size = urlToSeek.size();
            Iterator it = urlToSeek.iterator();
            while (it.hasNext()) {
                URL url = (URL)it.next();
                if (Resource.containsDirectDirectory(url, "i18n")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("skip url with no i18n directory : " + url));
                }
                it.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("detect " + urlToSeek.size() + " i18n capable url (out of " + size + ")"));
            }
            List<URL> result = Resource.getURLs(".*i18n/.+\\.properties", urlToSeek.toArray(new URL[urlToSeek.size()]));
            if (log.isDebugEnabled()) {
                for (URL url : result) {
                    log.debug((Object)url.toString());
                }
            }
            return result.toArray(new URL[result.size()]);
        }
        catch (Exception eee) {
            log.warn((Object)("Unable to find urls for loader : " + loader + " for reason " + eee.getMessage()), (Throwable)eee);
            return new URL[0];
        }
    }
}

