/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.navigation.ItemNavigationCardPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ItemTreeNavigationAdapter
implements TreeSelectionListener {
    private static final Log log = LogFactory.getLog(ItemTreeNavigationAdapter.class);
    protected JAXXObject context;
    protected JAXXTree tree;
    protected ItemNavigationCardPanel cardPanel;

    public ItemTreeNavigationAdapter(JAXXObject context, JAXXTree tree, ItemNavigationCardPanel cardPanel) {
        this.context = context;
        this.tree = tree;
        this.cardPanel = cardPanel;
        tree.addTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeModel model;
        log.debug((Object)("Selection in JAXXTree changed" + e.getPath()));
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            path = e.getOldLeadSelectionPath();
        }
        if (!((model = this.tree.getModel()) instanceof JAXXTree.JAXXTreeModel)) {
            log.error((Object)"Its not an JAXXTreeModel");
            return;
        }
        Object lastPathComponent = path.getLastPathComponent();
        Item itemSelected = ((JAXXTree.JAXXTreeModel)model).findItem(lastPathComponent);
        this.cardPanel.showItem(itemSelected);
        this.valueChanged(itemSelected.getValue());
    }

    protected abstract void valueChanged(Object var1);
}

