/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.store.DataPage;
import org.h2.store.PageStore;

public class PageOutputStream
extends OutputStream {
    private final Trace trace;
    private PageStore store;
    private int type;
    private int parentPage;
    private int pageId;
    private int nextPage;
    private DataPage page;
    private int remaining;
    private final boolean allocateAtEnd;
    private byte[] buffer = new byte[1];
    private boolean needFlush;
    private final int streamId;
    private boolean writing;

    public PageOutputStream(PageStore pageStore, int n, int n2, int n3, int n4, boolean bl) {
        this.trace = pageStore.getTrace();
        this.store = pageStore;
        this.parentPage = n;
        this.pageId = n2;
        this.type = n3;
        this.allocateAtEnd = bl;
        this.streamId = n4;
        this.page = pageStore.createDataPage();
        this.initPage();
    }

    public void write(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.write(this.buffer);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void initPage() {
        this.page.reset();
        this.page.writeInt(this.parentPage);
        this.page.writeByte((byte)this.type);
        this.page.writeByte((byte)this.streamId);
        this.page.writeInt(0);
        this.remaining = this.store.getPageSize() - this.page.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.writing) {
            throw Message.throwInternalError("writing while still writing");
        }
        this.writing = true;
        try {
            while (n2 >= this.remaining) {
                this.page.write(byArray, n, this.remaining);
                n += this.remaining;
                n2 -= this.remaining;
                try {
                    this.nextPage = this.store.allocatePage(this.allocateAtEnd);
                }
                catch (SQLException sQLException) {
                    throw Message.convertToIOException(sQLException);
                }
                this.page.setPos(4);
                this.page.writeByte((byte)this.type);
                this.page.writeByte((byte)this.streamId);
                this.page.writeInt(this.nextPage);
                this.storePage();
                this.parentPage = this.pageId;
                this.pageId = this.nextPage;
                this.initPage();
            }
            this.page.write(byArray, n, n2);
            this.needFlush = true;
            this.remaining -= n2;
        }
        finally {
            this.writing = false;
        }
    }

    private void storePage() throws IOException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("pageOut.storePage " + this.pageId + " next:" + this.nextPage);
            }
            this.store.writePage(this.pageId, this.page);
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        if (this.needFlush) {
            int n = this.page.length();
            this.page.setPos(4);
            this.page.writeByte((byte)(this.type | 0x10));
            this.page.writeByte((byte)this.streamId);
            this.page.writeInt(this.store.getPageSize() - this.remaining - 9);
            this.page.setPos(n);
            this.storePage();
            this.needFlush = false;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.store = null;
    }
}

