/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class FormManager {
    private static final Log log = LogFactory.getLog(FormManager.class);
    private final WikittyProxy proxy;
    private final ClientManager clientManager;
    private final ThesaurusManager thesaurusManager;
    private final SearchManager searchManager;
    public static final String TO_TREAT_STATUS_NAME = I18n._((String)"vradi.status.toTreat.name");
    public static final String TO_TREAT_STATUS_DESCRIPTION = I18n._((String)"vradi.status.toTreat.description");
    public static final String VALIDATED_STATUS_NAME = I18n._((String)"vradi.status.validated.name");
    public static final String VALIDATED_STATUS_DESCRIPTION = I18n._((String)"vradi.status.validated.description");
    public static final int TO_TREAT_STATUS_VALUE = 0;
    public static final int VALIDATED_STATUS_VALUE = 1;
    public static final SimpleDateFormat FORM_ID_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final int DEFAULT_SENDING_STATUS = 0;
    public static final String DEFAULT_SENDING_PARAGRAPH = "null";

    public FormManager(WikittyProxy proxy, ClientManager clientManager, ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.proxy = proxy;
        this.clientManager = clientManager;
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public FormManager(ClientManager clientManager, ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.proxy = ServiceHelper.getWikittyProxy();
        this.clientManager = clientManager;
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public List<Form> getAllForms() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllForms()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Form");
        Criteria criteria = search.criteria();
        PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
        List all = forms.getAll();
        return all;
    }

    public List<Form> getForms(List<String> formIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getForms(" + formIds + ")"));
        }
        List forms = this.proxy.restore(Form.class, formIds);
        return forms;
    }

    public Form getForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getForm(" + formId + ")"));
        }
        Form form = (Form)this.proxy.restore(Form.class, formId);
        return form;
    }

    public void deleteForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteForm(" + formId + ")"));
        }
        this.proxy.delete(formId);
    }

    public Form updateForm(Form form) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForm(form)");
        }
        List<Form> forms = Arrays.asList(form);
        List<Form> updateForms = this.updateForms(forms);
        Form updatedForm = updateForms.get(0);
        return updatedForm;
    }

    public List<Form> updateForms(List<Form> forms) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForms(forms)");
        }
        ArrayList<TreeNode> thesaurusList = new ArrayList<TreeNode>();
        for (Form form : forms) {
            Set thesaurus;
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating form: " + form.getId()));
            }
            if (form.getCreationDate() == null) {
                form.setCreationDate(new Date());
            } else {
                if (!form.getExtensionNames().contains("ModificationTag")) {
                    form.addExtension(ModificationTag.MODIFICATION_TAG);
                }
                form.setField("ModificationTag", "lastModified", (Object)new Date());
            }
            if ((thesaurus = form.getThesaurus()) == null) continue;
            for (String thesaurusId : thesaurus) {
                TreeNode node = this.thesaurusManager.getThesaurus(thesaurusId);
                if (node.getChildren() != null && node.getChildren().contains(form.getWikittyId())) continue;
                node.addChildren(form.getWikittyId());
                if (thesaurusList.contains(node)) continue;
                thesaurusList.add(node);
            }
        }
        this.proxy.store(thesaurusList);
        List result = this.proxy.store(forms);
        return result;
    }

    public Map<Form, List<Client>> getClientsByForms(String dateType, Date beginDate, Date endDate, WikittyExtension extension) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClientsByForms(dateType, beginDate, endDate, extension)");
        }
        HashMap<Form, List<Client>> clientsByForm = new HashMap<Form, List<Client>>();
        List<Form> forms = this.getAllForms();
        for (Form form : forms) {
            int dot;
            String dateExtension = null;
            String dateTypeName = null;
            if (dateType != null && (dot = dateType.indexOf(46)) > 0) {
                dateExtension = dateType.substring(0, dot);
                dateTypeName = dateType.substring(dot + 1);
            }
            Date date = (Date)form.getField(dateExtension, dateTypeName);
            if (extension != null && !form.getExtensions().contains(extension) || dateType != null && beginDate != null && beginDate.after(date) || dateType != null && endDate != null && endDate.before(date)) continue;
            ArrayList<String> clientIds = new ArrayList<String>();
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.form", form.getWikittyId()).criteria();
            PagedResult sendings = this.proxy.findAllByCriteria(Sending.class, criteria);
            List sendingList = sendings.getAll();
            for (Sending sending : sendingList) {
                clientIds.add(sending.getClient());
            }
            if (clientIds.isEmpty()) continue;
            List clients = this.proxy.restore(Client.class, clientIds);
            clientsByForm.put(form, clients);
        }
        return clientsByForm;
    }

    public List<VradiSendingDTO> getFormsByClients(String dateType, Date beginDate, Date endDate, WikittyExtension extension, Boolean receptionProof, Boolean paragraph, int status) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFormsByClients(dateType, beginDate, endDate, extension, receptionProof, paragraph, status)");
        }
        ArrayList<VradiSendingDTO> formsByClients = new ArrayList<VradiSendingDTO>();
        List<Client> clients = this.clientManager.getAllClients();
        for (Client client : clients) {
            Search search = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.client", client.getWikittyId());
            if (receptionProof != null) {
                search.eq("Sending.receptionProof", receptionProof.toString());
            }
            if (paragraph != null) {
                if (paragraph.booleanValue()) {
                    search.neq("Sending.paragraph", DEFAULT_SENDING_PARAGRAPH);
                } else {
                    search.eq("Sending.paragraph", DEFAULT_SENDING_PARAGRAPH);
                }
            }
            if (status >= 0) {
                search.eq("Sending.status", String.valueOf(status));
            }
            Criteria criteria = search.criteria();
            PagedResult sendings = this.proxy.findAllByCriteria(Sending.class, criteria);
            List sendingsList = sendings.getAll();
            for (Sending sending : sendingsList) {
                int dot;
                Set sendingForm = sending.getForm();
                ArrayList<Form> forms = new ArrayList<Form>();
                if (sendingForm != null && !sendingForm.isEmpty()) {
                    List<Form> forms2 = this.getForms(new ArrayList<String>(sendingForm));
                    forms.addAll(forms2);
                }
                String dateExtension = null;
                String dateTypeName = null;
                if (dateType != null && (dot = dateType.indexOf(46)) > 0) {
                    dateExtension = dateType.substring(0, dot);
                    dateTypeName = dateType.substring(dot + 1);
                }
                ArrayList<Form> formsToSend = new ArrayList<Form>();
                for (Form form : forms) {
                    Date date = (Date)form.getField(dateExtension, dateTypeName);
                    if (extension != null && !form.getExtensions().contains(extension) || dateType != null && beginDate != null && beginDate.after(date) || dateType != null && endDate != null && endDate.before(date)) continue;
                    formsToSend.add(form);
                }
                if (formsToSend.isEmpty()) continue;
                VradiSendingDTO formsByClient = new VradiSendingDTO(sending);
                formsByClient.setFormDTOs(formsToSend);
                formsByClients.add(formsByClient);
            }
        }
        return formsByClients;
    }

    public void bindFormsToClients() {
        block13: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"bindFormsToClients()");
            }
            ArrayList<SendingImpl> toSend = new ArrayList<SendingImpl>();
            try {
                ArrayList<Object> queryMakers = new ArrayList<Object>();
                List<Client> clients = this.clientManager.getAllClients();
                for (Client client : clients) {
                    Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.client", client.getWikittyId()).criteria();
                    List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
                    ArrayList<String> alreadyBoundFormIds = new ArrayList<String>();
                    for (Sending sending : sendings) {
                        if (sending.getForm() == null) continue;
                        alreadyBoundFormIds.addAll(sending.getForm());
                    }
                    queryMakers.add(client);
                    List<User> users = this.clientManager.getClientUsers(client.getWikittyId());
                    queryMakers.addAll(users);
                    ArrayList<String> formsToBindIds = new ArrayList<String>();
                    for (QueryMaker queryMaker : queryMakers) {
                        if (queryMaker.getQueries() == null) continue;
                        Set queries = queryMaker.getQueries();
                        for (String query : queries) {
                            VradiFormPageDTO vradiFormPage = new VradiFormPageDTO();
                            try {
                                this.searchManager.findForms(query, vradiFormPage);
                                List<Form> forms = vradiFormPage.getFormsToShow();
                                for (Form form : forms) {
                                    if (alreadyBoundFormIds.contains(form.getWikittyId())) continue;
                                    formsToBindIds.add(form.getWikittyId());
                                }
                            }
                            catch (UnsupportedQueryException e) {
                                log.warn((Object)"it seems that a persisted query is not supported anymore", (Throwable)e);
                            }
                        }
                    }
                    SendingImpl newSending = new SendingImpl();
                    for (Sending sending : sendings) {
                        if (sending.getStatus() != 0) continue;
                        newSending = sending;
                        break;
                    }
                    if (!formsToBindIds.isEmpty()) {
                        newSending.setClient(client.getWikittyId());
                        for (String formsToSendId : formsToBindIds) {
                            newSending.addForm(formsToSendId);
                            alreadyBoundFormIds.add(formsToSendId);
                        }
                        newSending.setSentDate(null);
                        newSending.setReceptionDate(null);
                        newSending.setParagraph(DEFAULT_SENDING_PARAGRAPH);
                        newSending.setReceptionProof(false);
                        newSending.setStatus(0);
                        toSend.add(newSending);
                    }
                    queryMakers.clear();
                }
                this.proxy.store(toSend);
            }
            catch (TechnicalException eee) {
                if (!log.isErrorEnabled()) break block13;
                log.error((Object)eee);
            }
        }
    }

    public Status getStatus(String statusId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatus(" + statusId + ")"));
        }
        Status status = (Status)this.proxy.restore(Status.class, statusId);
        return status;
    }

    public List<Status> getStatuses(List<String> statusIds) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getStatuses(statusIds)");
        }
        List statuses = this.proxy.restore(Status.class, statusIds);
        return new ArrayList<Status>(statuses);
    }

    public List<Status> getAllStatuses() throws TechnicalException {
        Search search;
        Criteria criteria;
        PagedResult statuses;
        ArrayList<Status> all;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllStatus()");
        }
        if ((all = (statuses = this.proxy.findAllByCriteria(Status.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "Status")).criteria())).getAll()) == null || all.isEmpty()) {
            log.warn((Object)"no status found, creating ...");
            all = new ArrayList<Status>();
            all.add(this.getToTreatStatus());
            all.add(this.getValidatedStatus());
        }
        return new ArrayList<Status>(all);
    }

    public Status getToTreatStatus() {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
        search.eq("Status.name", TO_TREAT_STATUS_NAME);
        Criteria criteria = search.criteria();
        Status toTreatStatus = (Status)this.proxy.findByCriteria(Status.class, criteria);
        if (toTreatStatus == null) {
            toTreatStatus = new StatusImpl();
            toTreatStatus.setName(TO_TREAT_STATUS_NAME);
            toTreatStatus.setValue(0);
            toTreatStatus.setDescription(TO_TREAT_STATUS_DESCRIPTION);
            toTreatStatus.setModifiable(false);
            toTreatStatus = (Status)this.proxy.store((BusinessEntity)toTreatStatus);
        }
        return toTreatStatus;
    }

    public Status getValidatedStatus() {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
        search.eq("Status.name", VALIDATED_STATUS_NAME);
        Criteria criteria = search.criteria();
        Status validatedStatus = (Status)this.proxy.findByCriteria(Status.class, criteria);
        if (validatedStatus == null) {
            validatedStatus = new StatusImpl();
            validatedStatus.setName(VALIDATED_STATUS_NAME);
            validatedStatus.setValue(1);
            validatedStatus.setDescription(VALIDATED_STATUS_DESCRIPTION);
            validatedStatus.setModifiable(false);
            validatedStatus = (Status)this.proxy.store((BusinessEntity)validatedStatus);
        }
        return validatedStatus;
    }

    public List<Status> updateStatuses(List<Status> statuses) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatuses(statuses)");
        }
        List result = this.proxy.store(statuses);
        return result;
    }

    public Status updateStatus(Status status) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatus(status)");
        }
        List<Status> statuses = Arrays.asList(status);
        List<Status> updateStatuses = this.updateStatuses(statuses);
        Status updatedStatus = updateStatuses.get(0);
        return updatedStatus;
    }

    public void deleteStatuses(List<String> statusIds) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteStatus(" + statusIds + ")"));
        }
        this.proxy.delete(statusIds);
    }
}

