/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserBean;
import com.jurismarches.vradi.services.dto.VradiDTO;
import java.util.Date;
import java.util.HashSet;

public class VradiUserDTO
extends UserBean
implements VradiDTO<User> {
    private static final long serialVersionUID = 1L;

    public VradiUserDTO() {
        this.QueryMaker$queries = new HashSet();
    }

    @Override
    public void fromWikitty(User wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setCreationDate(wikitty.getCreationDate());
            this.setAddress(wikitty.getAddress());
            this.setEmail(wikitty.getEmail());
            this.setName(wikitty.getName());
            this.setPhone(wikitty.getPhone());
            this.setService(wikitty.getService());
            this.setValidEmail(wikitty.getValidEmail());
            if (wikitty.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField("ModificationTag", "lastModified");
                this.setLastModified(lastModified != null ? (Date)lastModified : null);
                Object lastModifier = wikitty.getField("ModificationTag", "lastModifier");
                this.setLastModifier(lastModifier != null ? (String)lastModifier : null);
            } else {
                this.setLastModified(null);
                this.setLastModifier(null);
            }
            this.QueryMaker$queries.clear();
            this.addAllQueries(wikitty.getQueries());
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setCreationDate(null);
        this.setAddress(null);
        this.setEmail(null);
        this.setName(null);
        this.setPhone(null);
        this.setService(null);
        this.setValidEmail(false);
        this.setLastModified(null);
        this.setLastModifier(null);
        this.clearQueries();
    }

    @Override
    public void toWikitty(User wikitty) {
        wikitty.setCreationDate(this.getCreationDate());
        wikitty.setAddress(this.getAddress());
        wikitty.setEmail(this.getEmail());
        wikitty.setName(this.getName());
        wikitty.setPhone(this.getPhone());
        wikitty.setService(this.getService());
        wikitty.setValidEmail(this.getValidEmail());
        wikitty.setField("ModificationTag", "lastModified", (Object)this.getLastModified());
        wikitty.setField("ModificationTag", "lastModifier", (Object)this.getLastModifier());
        wikitty.clearQueries();
        for (String id : this.getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Date getLastModified() {
        return (Date)this.getField("ModificationTag", "lastModified");
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = this.getLastModified();
        this.setField("ModificationTag", "lastModified", lastModified);
        this.propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String)this.getField("ModificationTag", "lastModifier");
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = this.getLastModifier();
        this.setField("ModificationTag", "lastModifier", lastModifier);
        this.propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.QueryMaker$queries.add(s);
            }
        }
        this.propertyChange.firePropertyChange("queries", null, this.QueryMaker$queries);
    }
}

