package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class XmlFieldBindingImpl extends BusinessEntityWikitty implements XmlFieldBinding {

    private static final long serialVersionUID = 1190744311L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionXmlFieldBinding =
        new WikittyExtension(EXT_XMLFIELDBINDING, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String xmlField[0-*] unique",
				"String formField unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionXmlFieldBinding);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public XmlFieldBindingImpl() {
		super();
	}

    public XmlFieldBindingImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public XmlFieldBindingImpl(Wikitty wi) {
		super(wi);
	}

    public Set<String> getXmlField() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_XMLFIELDBINDING, "xmlField", String.class);
        return result;
    }

    public void addXmlField(String element) {
        getWikitty().addToField(EXT_XMLFIELDBINDING, "xmlField", element);
    }
    
    public void removeXmlField(String element) {
        getWikitty().removeFromField(EXT_XMLFIELDBINDING, "xmlField", element);
    }
    
    public void clearXmlField() {
        getWikitty().clearField(EXT_XMLFIELDBINDING, "xmlField");
    }


    public void setFormField(String formField) {
        getWikitty().setField(EXT_XMLFIELDBINDING, "formField", formField);
    }

    public String getFormField() {
        String result = getWikitty().getFieldAsString(EXT_XMLFIELDBINDING, "formField");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //XmlFieldBindingImpl
