package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class QueryMakerImpl extends BusinessEntityWikitty implements QueryMaker {

    private static final long serialVersionUID = 509784275L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionQueryMaker =
        new WikittyExtension(EXT_QUERYMAKER, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String queries[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionQueryMaker);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public QueryMakerImpl() {
		super();
	}

    public QueryMakerImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public QueryMakerImpl(Wikitty wi) {
		super(wi);
	}

    public Set<String> getQueries() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, "queries", String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, "queries");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //QueryMakerImpl
