package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class FormImpl extends BusinessEntityWikitty implements Form {

    private static final long serialVersionUID = -1588043403L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionForm =
        new WikittyExtension(EXT_FORM, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"Date datePub unique",
				"Numeric statut unique",
				"String thesaurus[0-*] unique",
				"Date datePeremption unique",
				"String id unique",
				"Wikitty sending[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionForm);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public FormImpl() {
		super();
	}

    public FormImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public FormImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_FORM, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_FORM, "name");
        return result;
    }


    public void setDatePub(Date datePub) {
        getWikitty().setField(EXT_FORM, "datePub", datePub);
    }

    public Date getDatePub() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, "datePub");
        return result;
    }


    public void setStatut(int statut) {
        getWikitty().setField(EXT_FORM, "statut", statut);
    }

    public int getStatut() {
        int result = getWikitty().getFieldAsInt(EXT_FORM, "statut");
        return result;
    }

    public Set<String> getThesaurus() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "thesaurus", String.class);
        return result;
    }

    public void addThesaurus(String element) {
        getWikitty().addToField(EXT_FORM, "thesaurus", element);
    }
    
    public void removeThesaurus(String element) {
        getWikitty().removeFromField(EXT_FORM, "thesaurus", element);
    }
    
    public void clearThesaurus() {
        getWikitty().clearField(EXT_FORM, "thesaurus");
    }


    public void setDatePeremption(Date datePeremption) {
        getWikitty().setField(EXT_FORM, "datePeremption", datePeremption);
    }

    public Date getDatePeremption() {
        Date result = getWikitty().getFieldAsDate(EXT_FORM, "datePeremption");
        return result;
    }


    public void setId(String id) {
        getWikitty().setField(EXT_FORM, "id", id);
    }

    public String getId() {
        String result = getWikitty().getFieldAsString(EXT_FORM, "id");
        return result;
    }

    public Set<String> getSending() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_FORM, "sending", String.class);
        return result;
    }

    public void addSending(String element) {
        getWikitty().addToField(EXT_FORM, "sending", element);
    }
    
    public void removeSending(String element) {
        getWikitty().removeFromField(EXT_FORM, "sending", element);
    }
    
    public void clearSending() {
        getWikitty().clearField(EXT_FORM, "sending");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //FormImpl
