/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.tree.components;

import com.jgeppert.struts2.jquery.components.AbstractRemoteBean;
import com.jgeppert.struts2.jquery.tree.components.Tree;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="treeItem", tldTagClass="com.jgeppert.struts2.jquery.tree.views.jsp.ui.TreeItemTag", description="Item for the Tree Element", allowDynamicAttributes=true)
public class TreeItem
extends AbstractRemoteBean {
    public static final String TEMPLATE = "tree-item";
    public static final String TEMPLATE_CLOSE = "tree-item-close";
    public static final String COMPONENT_NAME = TreeItem.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger(TreeItem.class);
    private static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "treeitem";
    protected String title;
    protected String type;

    public TreeItem(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        TreeItem parentTreeItem;
        Tree tree;
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", JQUERYACTION);
        if (this.title != null) {
            this.addParameter("title", this.findString(this.title));
        }
        if (this.type != null) {
            this.addParameter("type", this.findString(this.type));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = JQUERYACTION + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
        if ((tree = (Tree)this.findAncestor(Tree.class)) != null) {
            this.addParameter("tree", tree.getId());
        }
        if ((parentTreeItem = (TreeItem)this.findAncestor(TreeItem.class)) != null) {
            this.addParameter("parentTreeItem", parentTreeItem.getId());
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="Title for the Tree Item", required=true)
    public void setTitle(String title) {
        this.title = title;
    }

    @StrutsTagAttribute(description="The type property for node. This requires a valid types definition in the tree tag.")
    public void setType(String type) {
        this.type = type;
    }
}

