/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.write.RecordField;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.parquet.io.api.RecordConsumer;

class CollectionsWriters {
    private static final String LIST = "list";
    private static final String ELEMENT = "element";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String KEY_VALUE = "key_value";

    private CollectionsWriters() {
    }

    static Consumer<Object> twoLevelCollectionRecordFieldWriterFactory(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> elemConsumer) {
        if (recordField != null) {
            return new TwoLevelCollectionRecordFieldWriter(recordConsumer, recordField, elemConsumer);
        }
        return value -> {
            Collection coll = (Collection)value;
            if (coll != null) {
                CollectionsWriters.writeGroupElementTwo(recordConsumer, elemConsumer, coll);
            }
        };
    }

    private static void writeGroupElementTwo(RecordConsumer recordConsumer, BiConsumer<RecordConsumer, Object> innerStructureWriter, Collection<?> collection) {
        recordConsumer.startGroup();
        if (!collection.isEmpty()) {
            recordConsumer.startField(ELEMENT, 0);
            for (Object v : collection) {
                if (v == null) {
                    throw new NullPointerException("2-level list structures doesn't support null values");
                }
                innerStructureWriter.accept(recordConsumer, v);
            }
            recordConsumer.endField(ELEMENT, 0);
        }
        recordConsumer.endGroup();
    }

    static Consumer<Object> threeLevelCollectionRecordFieldWriterFactory(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> elemConsumer) {
        if (recordField != null) {
            return new ThreeLevelCollectionRecordFieldWriter(recordConsumer, recordField, elemConsumer);
        }
        return value -> {
            Collection coll = (Collection)value;
            if (coll != null) {
                recordConsumer.startGroup();
                if (!coll.isEmpty()) {
                    CollectionsWriters.writeGroupElementThree(recordConsumer, elemConsumer, coll);
                }
                recordConsumer.endGroup();
            }
        };
    }

    private static void writeGroupElementThree(RecordConsumer recordConsumer, BiConsumer<RecordConsumer, Object> innerStructureWriter, Collection<?> collection) {
        recordConsumer.startField(LIST, 0);
        for (Object v : collection) {
            recordConsumer.startGroup();
            if (v != null) {
                recordConsumer.startField(ELEMENT, 0);
                innerStructureWriter.accept(recordConsumer, v);
                recordConsumer.endField(ELEMENT, 0);
            }
            recordConsumer.endGroup();
        }
        recordConsumer.endField(LIST, 0);
    }

    static Consumer<Object> mapRecordFieldWriterFactory(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> elemKeyConsumer, BiConsumer<RecordConsumer, Object> elemValueConsumer) {
        if (elemValueConsumer == null || elemKeyConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in Map");
        }
        if (recordField != null) {
            return new MapRecordFieldWriter(recordConsumer, recordField, elemKeyConsumer, elemValueConsumer);
        }
        return value -> {
            if (value != null) {
                Map map = (Map)value;
                recordConsumer.startGroup();
                if (!map.isEmpty()) {
                    CollectionsWriters.writeKeyValueGroup(recordConsumer, elemKeyConsumer, elemValueConsumer, map);
                }
                recordConsumer.endGroup();
            }
        };
    }

    private static void writeKeyValueGroup(RecordConsumer recordConsumer, BiConsumer<RecordConsumer, Object> keyStructureWriter, BiConsumer<RecordConsumer, Object> valueStructureWriter, Map<?, ?> map) {
        recordConsumer.startField(KEY_VALUE, 0);
        for (Map.Entry<?, ?> v : map.entrySet()) {
            Object mapValue;
            recordConsumer.startGroup();
            if (v.getKey() != null) {
                recordConsumer.startField(KEY, 0);
                keyStructureWriter.accept(recordConsumer, v.getKey());
                recordConsumer.endField(KEY, 0);
            }
            if ((mapValue = v.getValue()) != null) {
                recordConsumer.startField(VALUE, 1);
                valueStructureWriter.accept(recordConsumer, mapValue);
                recordConsumer.endField(VALUE, 1);
            }
            recordConsumer.endGroup();
        }
        recordConsumer.endField(KEY_VALUE, 0);
    }

    private static class TwoLevelCollectionRecordFieldWriter
    extends CollectionFieldWriter {
        TwoLevelCollectionRecordFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter) {
            super(recordConsumer, recordField, innerStructureWriter);
        }

        @Override
        public void accept(Object object) {
            Collection coll = (Collection)this.accesor.apply(object);
            if (coll != null) {
                this.recordConsumer.startField(this.parquetFieldName, this.idx);
                CollectionsWriters.writeGroupElementTwo(this.recordConsumer, this.innerStructureWriter, coll);
                this.recordConsumer.endField(this.parquetFieldName, this.idx);
            }
        }
    }

    private static class ThreeLevelCollectionRecordFieldWriter
    extends CollectionFieldWriter {
        ThreeLevelCollectionRecordFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter) {
            super(recordConsumer, recordField, innerStructureWriter);
        }

        @Override
        public void accept(Object object) {
            Collection value = (Collection)this.accesor.apply(object);
            if (value != null) {
                this.recordConsumer.startField(this.parquetFieldName, this.idx);
                this.recordConsumer.startGroup();
                if (!value.isEmpty()) {
                    CollectionsWriters.writeGroupElementThree(this.recordConsumer, this.innerStructureWriter, value);
                }
                this.recordConsumer.endGroup();
                this.recordConsumer.endField(this.parquetFieldName, this.idx);
            }
        }
    }

    static class MapRecordFieldWriter
    implements Consumer<Object> {
        private final RecordConsumer recordConsumer;
        private final String parquetFieldName;
        private final int idx;
        private final Function<Object, Object> accesor;
        private final BiConsumer<RecordConsumer, Object> innerKeyStructureWriter;
        private final BiConsumer<RecordConsumer, Object> innerValueStructureWriter;

        MapRecordFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter, BiConsumer<RecordConsumer, Object> innerValueStructureWriter) {
            this.recordConsumer = recordConsumer;
            this.parquetFieldName = recordField.parquetFieldName();
            this.idx = recordField.idx();
            this.accesor = recordField.getAccessor();
            this.innerKeyStructureWriter = innerStructureWriter;
            this.innerValueStructureWriter = innerValueStructureWriter;
        }

        @Override
        public void accept(Object object) {
            Map value = (Map)this.accesor.apply(object);
            if (value != null) {
                this.recordConsumer.startField(this.parquetFieldName, this.idx);
                this.recordConsumer.startGroup();
                if (!value.isEmpty()) {
                    CollectionsWriters.writeKeyValueGroup(this.recordConsumer, this.innerKeyStructureWriter, this.innerValueStructureWriter, value);
                }
                this.recordConsumer.endGroup();
                this.recordConsumer.endField(this.parquetFieldName, this.idx);
            }
        }
    }

    static class OneLevelCollectionFieldWriter
    extends CollectionFieldWriter {
        OneLevelCollectionFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter) {
            super(recordConsumer, recordField, innerStructureWriter);
        }

        @Override
        public void accept(Object object) {
            Collection coll = (Collection)this.accesor.apply(object);
            if (coll != null && !coll.isEmpty()) {
                this.recordConsumer.startField(this.parquetFieldName, this.idx);
                for (Object v : coll) {
                    this.innerStructureWriter.accept(this.recordConsumer, v);
                }
                this.recordConsumer.endField(this.parquetFieldName, this.idx);
            }
        }
    }

    static abstract class CollectionFieldWriter
    implements Consumer<Object> {
        protected final RecordConsumer recordConsumer;
        protected final String parquetFieldName;
        protected final int idx;
        protected final Function<Object, Object> accesor;
        protected final BiConsumer<RecordConsumer, Object> innerStructureWriter;

        CollectionFieldWriter(RecordConsumer recordConsumer, RecordField recordField, BiConsumer<RecordConsumer, Object> innerStructureWriter) {
            this.recordConsumer = recordConsumer;
            this.parquetFieldName = recordField.parquetFieldName();
            this.idx = recordField.idx();
            this.accesor = recordField.getAccessor();
            this.innerStructureWriter = innerStructureWriter;
        }
    }
}

