/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.configuration.BuildConfigConstant;
import com.jayway.maven.plugins.android.phase01generatesources.ResourceClassGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class GenerateSourcesMojo
extends AbstractAndroidMojo {
    protected boolean mergeManifests;
    protected File genDirectory;
    protected File genDirectoryAidl;
    protected BuildConfigConstant[] buildConfigConstants;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isCurrentProjectAndroid()) {
            return;
        }
        try {
            this.targetDirectory.mkdirs();
            this.extractSourceDependencies();
            this.extractLibraryDependencies();
            this.copyFolder(this.assetsDirectory, this.combinedAssets);
            String[] relativeAidlFileNames1 = this.findRelativeAidlFileNames(this.sourceDirectory);
            String[] relativeAidlFileNames2 = this.findRelativeAidlFileNames(this.extractedDependenciesJavaSources);
            HashMap<String, String[]> relativeApklibAidlFileNames = new HashMap<String, String[]>();
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (!artifact.getType().equals("apklib")) continue;
                String[] apklibAidlFiles = this.findRelativeAidlFileNames(new File(this.getLibraryUnpackDirectory(artifact) + "/src"));
                relativeApklibAidlFileNames.put(artifact.getId(), apklibAidlFiles);
            }
            this.mergeManifests();
            this.generateR();
            this.generateApkLibRs();
            this.generateBuildConfig();
            HashMap<File, String[]> files = new HashMap<File, String[]>();
            files.put(this.sourceDirectory, relativeAidlFileNames1);
            files.put(this.extractedDependenciesJavaSources, relativeAidlFileNames2);
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (!artifact.getType().equals("apklib")) continue;
                files.put(new File(this.getLibraryUnpackDirectory(artifact) + "/src"), (String[])relativeApklibAidlFileNames.get(artifact.getId()));
            }
            this.generateAidlFiles(files);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error when generating sources.", (Throwable)e);
            throw e;
        }
    }

    protected void extractSourceDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apksources")) continue;
            this.getLog().debug((CharSequence)("Detected apksources dependency " + artifact + " with file " + artifact.getFile() + ". Will resolve and extract..."));
            Artifact resolvedArtifact = AetherHelper.resolveArtifact(artifact, this.repoSystem, this.repoSession, this.projectRepos);
            File apksourcesFile = resolvedArtifact.getFile();
            if (!apksourcesFile.exists()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            if (apksourcesFile.isDirectory()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            this.getLog().debug((CharSequence)("Extracting " + apksourcesFile + "..."));
            this.extractApksources(apksourcesFile);
        }
        this.projectHelper.addResource(this.project, this.extractedDependenciesJavaResources.getAbsolutePath(), null, null);
        this.project.addCompileSourceRoot(this.extractedDependenciesJavaSources.getAbsolutePath());
    }

    private void extractApksources(File apksourcesFile) throws MojoExecutionException {
        if (apksourcesFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apksources artifact points to '" + apksourcesFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apksourcesFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        this.extractedDependenciesDirectory.mkdirs();
        unArchiver.setDestDirectory(this.extractedDependenciesDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apksourcesFile.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void extractLibraryDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (type.equals("apklib")) {
                this.getLog().debug((CharSequence)("Extracting apklib " + artifact.getArtifactId() + "..."));
                this.extractApklib(artifact);
                continue;
            }
            if (type.equals("aar")) {
                this.getLog().debug((CharSequence)("Extracting aar " + artifact.getArtifactId() + "..."));
                this.extractAarlib(artifact);
                continue;
            }
            this.getLog().debug((CharSequence)("Not extracting " + artifact.getArtifactId() + "..."));
        }
    }

    private void extractApklib(Artifact apklibArtifact) throws MojoExecutionException {
        Artifact resolvedArtifact = AetherHelper.resolveArtifact(apklibArtifact, this.repoSystem, this.repoSession, this.projectRepos);
        File apkLibFile = resolvedArtifact.getFile();
        if (!apkLibFile.exists()) {
            apkLibFile = this.resolveArtifactToFile(apklibArtifact);
        }
        if (apkLibFile.isDirectory()) {
            apkLibFile = this.resolveArtifactToFile(apklibArtifact);
        }
        if (apkLibFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apklib artifact points to '" + apkLibFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apkLibFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        File apklibDirectory = new File(this.getLibraryUnpackDirectory(apklibArtifact));
        apklibDirectory.mkdirs();
        unArchiver.setDestDirectory(apklibDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apklibDirectory.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        this.copyFolder(new File(apklibDirectory, "assets"), this.combinedAssets);
        this.projectHelper.addResource(this.project, apklibDirectory.getAbsolutePath() + "/src", null, Arrays.asList("**/*.java", "**/*.aidl"));
        this.project.addCompileSourceRoot(apklibDirectory.getAbsolutePath() + "/src");
    }

    private void extractAarlib(Artifact aarArtifact) throws MojoExecutionException {
        Artifact resolvedArtifact = AetherHelper.resolveArtifact(aarArtifact, this.repoSystem, this.repoSession, this.projectRepos);
        File aarFile = resolvedArtifact.getFile();
        if (!aarFile.exists()) {
            aarFile = this.resolveArtifactToFile(aarArtifact);
        }
        if (aarFile.isDirectory()) {
            aarFile = this.resolveArtifactToFile(aarArtifact);
        }
        if (aarFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The aar artifact points to '" + aarFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(aarFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        File aarDirectory = new File(this.getLibraryUnpackDirectory(aarArtifact));
        aarDirectory.mkdirs();
        unArchiver.setDestDirectory(aarDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + aarDirectory.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        this.copyFolder(new File(aarDirectory, "assets"), this.combinedAssets);
        this.projectHelper.addResource(this.project, aarDirectory.getAbsolutePath() + "/src", null, Arrays.asList("**/*.aidl"));
    }

    private void generateR() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Generating R file for " + this.project.getPackaging()));
        this.genDirectory.mkdirs();
        File[] overlayDirectories = this.getResourceOverlayDirectories();
        this.getLog().debug((CharSequence)("Resource overlay folders : " + Arrays.asList(overlayDirectories)));
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-f");
        commands.add("--no-crunch");
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            this.getLog().debug((CharSequence)("Adding resource overlay folder : " + resOverlayDir));
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.resourceDirectory.exists()) {
            this.getLog().debug((CharSequence)("Adding resource folder : " + this.resourceDirectory));
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apklibResDirectory;
            this.getLog().debug((CharSequence)("Considering dep artifact : " + artifact));
            if (!artifact.getType().equals("apklib") && !artifact.getType().equals("aar") || !new File(apklibResDirectory = this.getLibraryUnpackDirectory(artifact) + "/res").exists()) continue;
            this.getLog().debug((CharSequence)("Adding apklib or aar resource folder : " + apklibResDirectory));
            commands.add("-S");
            commands.add(apklibResDirectory);
        }
        if (this.combinedAssets.exists()) {
            this.getLog().debug((CharSequence)("Adding assets folder : " + this.combinedAssets));
            commands.add("-A");
            commands.add(this.combinedAssets.getAbsolutePath());
        }
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        if (this.proguardFile != null) {
            File parentFolder = this.proguardFile.getParentFile();
            if (parentFolder != null) {
                parentFolder.mkdirs();
            }
            this.getLog().debug((CharSequence)("Adding proguard file : " + this.proguardFile));
            commands.add("-G");
            commands.add(this.proguardFile.getAbsolutePath());
        }
        if (StringUtils.isNotBlank((String)this.customPackage)) {
            this.getLog().debug((CharSequence)("Adding custom-package : " + this.customPackage));
            commands.add("--custom-package");
            commands.add(this.customPackage);
        }
        if ("aar".equals(this.project.getArtifact().getType())) {
            this.getLog().debug((CharSequence)"Adding non-constant-id");
            commands.add("--non-constant-id");
        }
        for (String aaptExtraArg : this.aaptExtraArgs) {
            this.getLog().debug((CharSequence)("Adding aapt arg : " + (String)aaptExtraArg));
            commands.add(aaptExtraArg);
        }
        if (StringUtils.isNotBlank((String)this.configurations)) {
            this.getLog().debug((CharSequence)("Adding resource configurations : " + this.configurations));
            commands.add("-c");
            commands.add(this.configurations);
        }
        commands.add("--output-text-symbols");
        commands.add(this.targetDirectory.getAbsolutePath());
        commands.add("--auto-add-overlay");
        this.getLog().info((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + ((Object)commands).toString()));
        try {
            this.targetDirectory.mkdirs();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        List<Artifact> libraries = this.getLibraries();
        this.getLog().debug((CharSequence)("Generating R for " + libraries));
        if ("apk".equals(this.project.getArtifact().getType()) && !libraries.isEmpty()) {
            ResourceClassGenerator rGenerator = new ResourceClassGenerator(this, libraries, this.targetDirectory, this.genDirectory, this.getLog());
            rGenerator.generateLibraryRs();
        }
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void generateApkLibRs() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Generating Rs for apklib deps of project " + this.project.getArtifact()));
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            this.getLog().debug((CharSequence)("Generating apklib R.java for " + artifact.getArtifactId() + "..."));
            this.generateRForApkLibDependency(artifact);
        }
    }

    private void generateRForApkLibDependency(Artifact apklibArtifact) throws MojoExecutionException {
        String unpackDir = this.getLibraryUnpackDirectory(apklibArtifact);
        this.getLog().debug((CharSequence)("Generating R file for apklibrary: " + apklibArtifact.getGroupId() + ":" + apklibArtifact.getArtifactId()));
        File apklibManifest = new File(unpackDir, "AndroidManifest.xml");
        File apklibResDir = new File(unpackDir, "/res");
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("--non-constant-id");
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        commands.add("--custom-package");
        commands.add(this.extractPackageNameFromAndroidManifest(apklibManifest));
        commands.add("-M");
        commands.add(apklibManifest.getAbsolutePath());
        if (apklibResDir.exists()) {
            commands.add("-S");
            commands.add(apklibResDir.getAbsolutePath());
        }
        List<Artifact> apklibDependencies = this.getDependencyResolver().getDependenciesFor(apklibArtifact);
        this.getLog().debug((CharSequence)("apklib dependencies = " + apklibDependencies));
        for (Artifact dependency : apklibDependencies) {
            String extension = dependency.getType();
            String dependencyResDir = this.getLibraryUnpackDirectory(dependency) + "/res";
            if (!extension.equals("apklib") && !extension.equals("aar") || !new File(dependencyResDir).exists()) continue;
            commands.add("-S");
            commands.add(dependencyResDir);
        }
        commands.add("--auto-add-overlay");
        File apklibCombAssets = new File(this.getLibraryUnpackDirectory(apklibArtifact), "combined-assets");
        for (Artifact dependency : apklibDependencies) {
            String extension = dependency.getType();
            File dependencyAssetsDir = new File(this.getLibraryUnpackDirectory(dependency), "assets");
            if (!extension.equals("apklib") && !extension.equals("aar")) continue;
            this.copyFolder(dependencyAssetsDir, apklibCombAssets);
        }
        File apkLibAssetsDir = new File(this.getLibraryUnpackDirectory(apklibArtifact), "assets");
        this.copyFolder(apkLibAssetsDir, apklibCombAssets);
        if (apklibCombAssets.exists()) {
            commands.add("-A");
            commands.add(apklibCombAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        for (String aaptExtraArg : this.aaptExtraArgs) {
            commands.add(aaptExtraArg);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private List<Artifact> getLibraries() {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apklib") && !type.equals("aar")) continue;
            result.add(artifact);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mergeManifests() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("mergeManifests: " + this.mergeManifests));
        if (!this.mergeManifests) {
            this.getLog().info((CharSequence)"Manifest merging disabled. Using project manifest only");
            return;
        }
        this.getLog().info((CharSequence)"Getting manifests of dependent apklibs");
        ArrayList<File> libManifests = new ArrayList<File>();
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib") && !artifact.getType().equals("aar")) continue;
            File apklibManifeset = new File(this.getLibraryUnpackDirectory(artifact), "AndroidManifest.xml");
            if (!apklibManifeset.exists()) {
                throw new MojoExecutionException(artifact.getArtifactId() + " is missing AndroidManifest.xml");
            }
            libManifests.add(apklibManifeset);
        }
        if (libManifests.isEmpty()) {
            this.getLog().info((CharSequence)"No APKLIB manifests found. Using project manifest only.");
            return;
        }
        File mergedManifest = new File(this.androidManifestFile.getParent(), "AndroidManifest-merged.xml");
        StdLogger stdLogger = new StdLogger(StdLogger.Level.VERBOSE);
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)stdLogger), null);
        this.getLog().info((CharSequence)"Merging manifests of dependent apklibs");
        boolean mergeSuccess = merger.process(mergedManifest, this.androidManifestFile, libManifests.toArray(new File[libManifests.size()]), null, null);
        if (mergeSuccess) {
            this.androidManifestFile.delete();
            mergedManifest.renameTo(this.androidManifestFile);
            this.getLog().info((CharSequence)"Done Merging Manifests of APKLIBs");
            return;
        }
        this.getLog().error((CharSequence)"Manifests were not merged!");
        throw new MojoExecutionException("Manifests were not merged!");
    }

    private void generateBuildConfig() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BuildConfig file");
        String packageName = this.extractPackageNameFromAndroidManifest(this.androidManifestFile);
        if (StringUtils.isNotBlank((String)this.customPackage)) {
            packageName = this.customPackage;
        }
        this.generateBuildConfigForPackage(packageName);
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            File apklibManifeset = new File(this.getLibraryUnpackDirectory(artifact), "AndroidManifest.xml");
            String apklibPackageName = this.extractPackageNameFromAndroidManifest(apklibManifeset);
            this.generateBuildConfigForPackage(apklibPackageName);
        }
    }

    private void generateBuildConfigForPackage(String packageName) throws MojoExecutionException {
        File outputFolder = new File(this.genDirectory, packageName.replace(".", File.separator));
        outputFolder.mkdirs();
        StringBuilder buildConfig = new StringBuilder();
        buildConfig.append("package ").append(packageName).append(";\n\n");
        buildConfig.append("public final class BuildConfig {\n");
        buildConfig.append("  public static final boolean DEBUG = ").append(!this.release).append(";\n");
        for (BuildConfigConstant constant : this.buildConfigConstants) {
            String value = constant.getValue();
            if ("String".equals(constant.getType())) {
                value = "\"" + value + "\"";
            }
            buildConfig.append("  public static final ").append(constant.getType()).append(" ").append(constant.getName()).append(" = ").append(value).append(";\n");
        }
        buildConfig.append("}\n");
        File outputFile = new File(outputFolder, "BuildConfig.java");
        try {
            FileUtils.writeStringToFile((File)outputFile, (String)buildConfig.toString());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error generating BuildConfig ", (Throwable)e);
            throw new MojoExecutionException("Error generating BuildConfig", (Exception)e);
        }
    }

    private void generateAidlFiles(Map<File, String[]> files) throws MojoExecutionException {
        ArrayList<String> protoCommands = new ArrayList<String>();
        protoCommands.add("-p" + this.getAndroidSdk().getPathForFrameworkAidl());
        this.genDirectoryAidl.mkdirs();
        this.project.addCompileSourceRoot(this.genDirectoryAidl.getPath());
        Set<File> sourceDirs = files.keySet();
        for (File sourceDir : sourceDirs) {
            protoCommands.add("-I" + sourceDir);
        }
        for (File sourceDir : sourceDirs) {
            for (String relativeAidlFileName : files.get(sourceDir)) {
                File targetDirectory = new File(this.genDirectoryAidl, new File(relativeAidlFileName).getParent());
                targetDirectory.mkdirs();
                String shortAidlFileName = new File(relativeAidlFileName).getName();
                String shortJavaFileName = shortAidlFileName.substring(0, shortAidlFileName.lastIndexOf(".")) + ".java";
                File aidlFileInSourceDirectory = new File(sourceDir, relativeAidlFileName);
                ArrayList<String> commands = new ArrayList<String>(protoCommands);
                commands.add(aidlFileInSourceDirectory.getAbsolutePath());
                commands.add(new File(targetDirectory, shortJavaFileName).getAbsolutePath());
                try {
                    CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
                    executor.setLogger(this.getLog());
                    executor.executeCommand(this.getAndroidSdk().getAidlPath(), commands, this.project.getBasedir(), false);
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException("", (Exception)e);
                }
            }
        }
    }

    private String[] findRelativeAidlFileNames(File sourceDirectory) {
        String[] relativeAidlFileNames = this.findFilesInDirectory(sourceDirectory, "**/*.aidl");
        this.getLog().info((CharSequence)("ANDROID-904-002: Found aidl files: Count = " + relativeAidlFileNames.length));
        return relativeAidlFileNames;
    }

    private boolean isCurrentProjectAndroid() {
        HashSet<String> androidArtifacts = new HashSet<String>(){
            {
                this.addAll(Arrays.asList("apk", "apklib", "apksources", "aar"));
            }
        };
        return androidArtifacts.contains(this.project.getArtifact().getType());
    }
}

