/*
 * Decompiled with CFR 0.152.
 */
package com.infradna.tool.bridge_method_injector;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.ClassAnnotationInjector;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.tree.AnnotationNode;

public class MethodInjector {
    private static final String SYNTHETIC_METHODS_ADDED = Type.getDescriptor(BridgeMethodsAdded.class);
    private static final String WITH_SYNTHETIC_METHODS = Type.getDescriptor(WithBridgeMethods.class);

    public void handleRecursively(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.handleRecursively(c);
            }
        } else if (f.getName().endsWith(".class")) {
            this.handle(f);
        }
    }

    public void handle(File classFile) throws IOException {
        byte[] image;
        FileInputStream in = new FileInputStream(classFile);
        try {
            ClassReader cr = new ClassReader((InputStream)new BufferedInputStream(in));
            ClassWriter cw = new ClassWriter(cr, 1);
            cr.accept((ClassVisitor)new Transformer((ClassVisitor)new ClassAnnotationInjectorImpl((ClassVisitor)cw)), 0);
            image = cw.toByteArray();
        }
        catch (AlreadyUpToDate _) {
            return;
        }
        catch (IOException e) {
            throw (IOException)new IOException("Failed to process " + classFile).initCause(e);
        }
        catch (RuntimeException e) {
            throw (IOException)new IOException("Failed to process " + classFile).initCause(e);
        }
        finally {
            in.close();
        }
        FileOutputStream out = new FileOutputStream(classFile);
        out.write(image);
        out.close();
    }

    public static void main(String[] args) throws IOException {
        MethodInjector mi = new MethodInjector();
        for (String a : args) {
            mi.handleRecursively(new File(a));
        }
    }

    class Transformer
    extends ClassAdapter {
        private String internalClassName;
        private final List<SyntheticMethod> syntheticMethods;

        Transformer(ClassVisitor cv) {
            super(cv);
            this.syntheticMethods = new ArrayList<SyntheticMethod>();
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.internalClassName = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(SYNTHETIC_METHODS_ADDED)) {
                throw new AlreadyUpToDate();
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(final int access, final String name, final String mdesc, final String signature, final String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, mdesc, signature, exceptions);
            return new MethodAdapter(mv){

                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    final AnnotationVisitor av = super.visitAnnotation(adesc, visible);
                    if (adesc.equals(WITH_SYNTHETIC_METHODS)) {
                        return new AnnotationNode(adesc){

                            public void visitEnd() {
                                super.visitEnd();
                                this.accept(av);
                                WithBridgeMethodsAnnotationVisitor annotationVisitor = new WithBridgeMethodsAnnotationVisitor();
                                this.accept((AnnotationVisitor)annotationVisitor);
                                for (Type type : annotationVisitor.types) {
                                    Transformer.this.syntheticMethods.add(new SyntheticMethod(access, name, mdesc, signature, exceptions, type, annotationVisitor.castRequired));
                                }
                            }
                        };
                    }
                    return av;
                }
            };
        }

        public void visitEnd() {
            for (SyntheticMethod m : this.syntheticMethods) {
                m.inject(this.cv);
            }
            super.visitEnd();
        }

        class SyntheticMethod {
            final int access;
            final String name;
            final String desc;
            final String originalSignature;
            final String[] exceptions;
            final boolean castRequired;
            final Type returnType;

            SyntheticMethod(int access, String name, String desc, String originalSignature, String[] exceptions, Type returnType, boolean castRequired) {
                this.access = access;
                this.name = name;
                this.desc = desc;
                this.originalSignature = originalSignature;
                this.exceptions = exceptions;
                this.returnType = returnType;
                this.castRequired = castRequired;
            }

            public void inject(ClassVisitor cv) {
                boolean isStatic;
                Type[] paramTypes = Type.getArgumentTypes((String)this.desc);
                MethodVisitor mv = cv.visitMethod(this.access | 0x1000 | 0x40, this.name, Type.getMethodDescriptor((Type)this.returnType, (Type[])paramTypes), null, this.exceptions);
                mv.visitCode();
                int sz = 0;
                boolean bl = isStatic = (this.access & 8) != 0;
                if (!isStatic) {
                    mv.visitVarInsn(25, 0);
                    ++sz;
                }
                for (Type p : paramTypes) {
                    mv.visitVarInsn(p.getOpcode(21), sz);
                    sz += p.getSize();
                }
                mv.visitMethodInsn(isStatic ? 184 : 182, Transformer.this.internalClassName, this.name, this.desc);
                if (this.castRequired) {
                    mv.visitTypeInsn(192, this.returnType.getInternalName());
                }
                mv.visitInsn(this.returnType.getOpcode(172));
                mv.visitMaxs(sz, 0);
                mv.visitEnd();
            }
        }
    }

    private static class WithBridgeMethodsAnnotationVisitor
    extends EmptyVisitor {
        private boolean castRequired = false;
        private List<Type> types = new ArrayList<Type>();

        private WithBridgeMethodsAnnotationVisitor() {
        }

        public void visit(String name, Object value) {
            if ("castRequired".equals(name) && value instanceof Boolean) {
                this.castRequired = (Boolean)value;
            }
            if (value instanceof Type) {
                this.types.add((Type)value);
            }
        }
    }

    static class ClassAnnotationInjectorImpl
    extends ClassAnnotationInjector {
        ClassAnnotationInjectorImpl(ClassVisitor cv) {
            super(cv);
        }

        protected void emit() {
            AnnotationVisitor av = this.cv.visitAnnotation(SYNTHETIC_METHODS_ADDED, false);
            av.visitEnd();
        }
    }

    class AlreadyUpToDate
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AlreadyUpToDate() {
        }
    }
}

