/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;

public class Filter
extends Transform {
    private final int index;
    private final MethodHandle[] functions;
    public static final String FILTER_FUNCTIONS_JAVA = "<filter functions>";

    public Filter(int index, MethodHandle ... functions) {
        this.index = index;
        this.functions = functions;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return MethodHandles.filterArguments(target, this.index, this.functions);
    }

    @Override
    public MethodType down(MethodType type) {
        for (int i = 0; i < this.functions.length; ++i) {
            type = type.changeParameterType(this.index + i, (Class<?>)this.functions[i].type().returnType());
        }
        return type;
    }

    @Override
    public String toString() {
        return "fold args from " + this.index + " with " + Arrays.toString(this.functions);
    }

    @Override
    public String toJava(MethodType incoming) {
        return "handle = MethodHandles.filterArguments(handle, " + this.index + ", " + FILTER_FUNCTIONS_JAVA + ");";
    }
}

