/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.DefaultGraphQLContextBuilder;
import graphql.servlet.DefaultGraphQLErrorHandler;
import graphql.servlet.DefaultGraphQLRootObjectBuilder;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLMutationProvider;
import graphql.servlet.GraphQLProvider;
import graphql.servlet.GraphQLQueryProvider;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServlet;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.GraphQLTypesProvider;
import graphql.servlet.GraphQLVariables;
import graphql.servlet.InstrumentationProvider;
import graphql.servlet.NoOpInstrumentationProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={HttpServlet.class, Servlet.class}, property={"alias=/graphql", "jmx.objectname=graphql.servlet:type=graphql"})
public class OsgiGraphQLServlet
extends GraphQLServlet {
    private final List<GraphQLQueryProvider> queryProviders = new ArrayList<GraphQLQueryProvider>();
    private final List<GraphQLMutationProvider> mutationProviders = new ArrayList<GraphQLMutationProvider>();
    private final List<GraphQLTypesProvider> typesProviders = new ArrayList<GraphQLTypesProvider>();
    private GraphQLContextBuilder contextBuilder = new DefaultGraphQLContextBuilder();
    private GraphQLRootObjectBuilder rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    private ExecutionStrategyProvider executionStrategyProvider = new DefaultExecutionStrategyProvider();
    private InstrumentationProvider instrumentationProvider = new NoOpInstrumentationProvider();
    private GraphQLErrorHandler errorHandler = new DefaultGraphQLErrorHandler();
    private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    private GraphQLSchemaProvider schemaProvider;

    /*
     * WARNING - void declaration
     */
    protected void updateSchema() {
        void var3_7;
        GraphQLObjectType.Builder queryTypeBuilder = GraphQLObjectType.newObject().name("Query").description("Root query type");
        for (GraphQLQueryProvider graphQLQueryProvider : this.queryProviders) {
            if (graphQLQueryProvider.getQueries() == null || graphQLQueryProvider.getQueries().isEmpty()) continue;
            graphQLQueryProvider.getQueries().forEach(arg_0 -> ((GraphQLObjectType.Builder)queryTypeBuilder).field(arg_0));
        }
        HashSet<GraphQLType> types = new HashSet<GraphQLType>();
        for (GraphQLTypesProvider typesProvider : this.typesProviders) {
            types.addAll(typesProvider.getTypes());
        }
        Object var3_5 = null;
        if (!this.mutationProviders.isEmpty()) {
            GraphQLObjectType.Builder mutationTypeBuilder = GraphQLObjectType.newObject().name("Mutation").description("Root mutation type");
            for (GraphQLMutationProvider provider : this.mutationProviders) {
                provider.getMutations().forEach(arg_0 -> ((GraphQLObjectType.Builder)mutationTypeBuilder).field(arg_0));
            }
            if (!mutationTypeBuilder.build().getFieldDefinitions().isEmpty()) {
                GraphQLObjectType graphQLObjectType = mutationTypeBuilder.build();
            }
        }
        this.schemaProvider = new DefaultGraphQLSchemaProvider(GraphQLSchema.newSchema().query(queryTypeBuilder.build()).mutation((GraphQLObjectType)var3_7).build(types));
    }

    public OsgiGraphQLServlet() {
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.add((GraphQLQueryProvider)provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.add((GraphQLMutationProvider)provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.typesProviders.add((GraphQLTypesProvider)provider);
        }
        this.updateSchema();
    }

    public void unbindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.remove(provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.remove(provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.typesProviders.remove(provider);
        }
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.add(queryProvider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.remove(queryProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.add(mutationProvider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.remove(mutationProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void typesProviders(GraphQLTypesProvider typesProvider) {
        this.typesProviders.add(typesProvider);
        this.updateSchema();
    }

    public void unbindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.typesProviders.remove(typesProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindServletListener(GraphQLServletListener listener) {
        this.addListener(listener);
    }

    public void unbindServletListener(GraphQLServletListener listener) {
        this.removeListener(listener);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    public void setContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    public void unsetContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = new DefaultGraphQLContextBuilder();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    public void setRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = rootObjectBuilder;
    }

    public void unsetRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
        this.rootObjectBuilder = new DefaultGraphQLRootObjectBuilder();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = provider;
    }

    public void unsetExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = new DefaultExecutionStrategyProvider();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setInstrumentationProvider(InstrumentationProvider provider) {
        this.instrumentationProvider = provider;
    }

    public void unsetInstrumentationProvider(InstrumentationProvider provider) {
        this.instrumentationProvider = new NoOpInstrumentationProvider();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void unsetErrorHandler(GraphQLErrorHandler errorHandler) {
        this.errorHandler = new DefaultGraphQLErrorHandler();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = preparsedDocumentProvider;
    }

    public void unsetPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
    }

    @Override
    protected GraphQLSchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    @Override
    protected GraphQLContext createContext(Optional<HttpServletRequest> req, Optional<HttpServletResponse> resp) {
        return this.contextBuilder.build(req, resp);
    }

    @Override
    protected Object createRootObject(Optional<HttpServletRequest> request, Optional<HttpServletResponse> response) {
        return this.rootObjectBuilder.build(request, response);
    }

    @Override
    protected ExecutionStrategyProvider getExecutionStrategyProvider() {
        return this.executionStrategyProvider;
    }

    @Override
    protected Instrumentation getInstrumentation() {
        return this.instrumentationProvider.getInstrumentation();
    }

    @Override
    protected Map<String, Object> transformVariables(GraphQLSchema schema, String query, Map<String, Object> variables) {
        return new GraphQLVariables(schema, query, variables);
    }

    @Override
    protected GraphQLErrorHandler getGraphQLErrorHandler() {
        return this.errorHandler;
    }

    @Override
    protected PreparsedDocumentProvider getPreparsedDocumentProvider() {
        return this.preparsedDocumentProvider;
    }
}

