/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.apt.TypeVisitorBase;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class TransportableTypeVisitor
extends TypeVisitorBase<Boolean> {
    private boolean allowNestedParameterization = true;

    TransportableTypeVisitor() {
    }

    @Override
    public Boolean visitDeclared(DeclaredType t, State state) {
        if (t.asElement().getKind().equals((Object)ElementKind.ENUM)) {
            return true;
        }
        if (state.types.isAssignable(t, state.entityProxyType) || state.types.isAssignable(t, state.valueProxyType)) {
            TypeElement proxyElement = (TypeElement)t.asElement();
            state.maybeScanProxy(proxyElement);
            state.requireMapping(proxyElement);
            return true;
        }
        if (state.types.isAssignable(t, state.entityProxyIdType)) {
            DeclaredType asId = (DeclaredType)State.viewAs(state.entityProxyIdType, t, state);
            if (asId.getTypeArguments().isEmpty()) {
                return false;
            }
            return asId.getTypeArguments().get(0).accept(this, state);
        }
        for (DeclaredType valueType : this.getValueTypes(state)) {
            if (!state.types.isAssignable(t, valueType)) continue;
            return true;
        }
        if (state.types.isAssignable(t, state.findType(List.class)) || state.types.isAssignable(t, state.findType(Set.class))) {
            if (!this.allowNestedParameterization) {
                return false;
            }
            this.allowNestedParameterization = false;
            DeclaredType asCollection = (DeclaredType)State.viewAs(state.findType(Collection.class), t, state);
            if (asCollection.getTypeArguments().isEmpty()) {
                return false;
            }
            return t.getTypeArguments().get(0).accept(this, state);
        }
        return false;
    }

    @Override
    public Boolean visitPrimitive(PrimitiveType x, State state) {
        return true;
    }

    @Override
    public Boolean visitTypeVariable(TypeVariable t, State state) {
        if (t.equals(t.getUpperBound())) {
            return state.types.erasure(t).accept(this, state);
        }
        return t.getUpperBound().accept(this, state);
    }

    @Override
    public Boolean visitWildcard(WildcardType t, State state) {
        return state.types.erasure(t).accept(this, state);
    }

    @Override
    protected Boolean defaultAction(TypeMirror arg0, State arg1) {
        return false;
    }
}

