/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=root

/**
 * Localized names for the "zh" locale.
 */
public class LocalizedNamesImpl_zh extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AL",
        "DZ",
        "AF",
        "AR",
        "AE",
        "AW",
        "OM",
        "AZ",
        "AC",
        "EG",
        "ET",
        "IE",
        "EE",
        "AD",
        "AO",
        "AI",
        "AG",
        "AT",
        "AX",
        "AU",
        "BB",
        "PG",
        "BS",
        "PK",
        "PY",
        "PS",
        "BH",
        "PA",
        "BR",
        "BY",
        "BM",
        "BG",
        "MP",
        "BJ",
        "BE",
        "IS",
        "BO",
        "PR",
        "PL",
        "BA",
        "BW",
        "BZ",
        "BT",
        "BF",
        "BI",
        "BV",
        "KP",
        "GQ",
        "QO",
        "DK",
        "DE",
        "DG",
        "TL",
        "TG",
        "DO",
        "DM",
        "RU",
        "EC",
        "ER",
        "FR",
        "FO",
        "PF",
        "GF",
        "TF",
        "MF",
        "PH",
        "FI",
        "CV",
        "FK",
        "GM",
        "CG",
        "CD",
        "CO",
        "CR",
        "GD",
        "GL",
        "GE",
        "GG",
        "CU",
        "GP",
        "GU",
        "GY",
        "KZ",
        "HT",
        "KR",
        "NL",
        "BQ",
        "AN",
        "SX",
        "HM",
        "ME",
        "HN",
        "KI",
        "DJ",
        "KG",
        "GN",
        "GW",
        "CA",
        "GH",
        "IC",
        "GA",
        "KH",
        "CZ",
        "ZW",
        "CM",
        "QA",
        "KY",
        "CC",
        "KM",
        "XK",
        "CI",
        "KW",
        "CP",
        "HR",
        "KE",
        "CK",
        "CW",
        "LV",
        "LS",
        "LA",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "RE",
        "LU",
        "RW",
        "RO",
        "MG",
        "MT",
        "MV",
        "MW",
        "MY",
        "ML",
        "MK",
        "MH",
        "MQ",
        "YT",
        "IM",
        "MU",
        "MR",
        "US",
        "UM",
        "AS",
        "VI",
        "MN",
        "MS",
        "BD",
        "PE",
        "FM",
        "MM",
        "MD",
        "MA",
        "MC",
        "MZ",
        "MX",
        "NA",
        "ZA",
        "AQ",
        "GS",
        "SS",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NF",
        "EU",
        "PW",
        "PN",
        "PT",
        "JP",
        "SE",
        "CH",
        "SV",
        "WS",
        "RS",
        "SL",
        "SN",
        "CY",
        "SC",
        "SA",
        "BL",
        "CX",
        "ST",
        "SH",
        "KN",
        "LC",
        "SM",
        "PM",
        "VC",
        "LK",
        "SK",
        "SI",
        "SJ",
        "SZ",
        "SD",
        "SR",
        "SO",
        "SB",
        "TJ",
        "TW",
        "TH",
        "TZ",
        "TO",
        "TC",
        "TA",
        "TT",
        "TN",
        "TV",
        "TR",
        "TM",
        "TK",
        "WF",
        "VU",
        "GT",
        "VE",
        "BN",
        "UG",
        "UA",
        "UY",
        "UZ",
        "ES",
        "EH",
        "GR",
        "SG",
        "NC",
        "NZ",
        "HU",
        "EA",
        "SY",
        "JM",
        "AM",
        "YE",
        "IQ",
        "IR",
        "IL",
        "IT",
        "IN",
        "ID",
        "GB",
        "VG",
        "IO",
        "JO",
        "VN",
        "ZM",
        "JE",
        "TD",
        "GI",
        "CL",
        "CF",
        "CN",
        "MO",
        "HK",
        "NR",
        "VA",
        "FJ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "世界");
    namesMap.put("002", "非洲");
    namesMap.put("003", "北美洲");
    namesMap.put("005", "南美洲");
    namesMap.put("009", "大洋洲");
    namesMap.put("011", "西非");
    namesMap.put("013", "中美洲");
    namesMap.put("014", "东非");
    namesMap.put("015", "北非");
    namesMap.put("017", "中非");
    namesMap.put("018", "南部非洲");
    namesMap.put("019", "美洲");
    namesMap.put("021", "美洲北部");
    namesMap.put("029", "加勒比地区");
    namesMap.put("030", "东亚");
    namesMap.put("034", "南亚");
    namesMap.put("035", "东南亚");
    namesMap.put("039", "南欧");
    namesMap.put("053", "澳大拉西亚");
    namesMap.put("054", "美拉尼西亚");
    namesMap.put("057", "密克罗尼西亚地区");
    namesMap.put("061", "玻利尼西亚");
    namesMap.put("142", "亚洲");
    namesMap.put("143", "中亚");
    namesMap.put("145", "西亚");
    namesMap.put("150", "欧洲");
    namesMap.put("151", "东欧");
    namesMap.put("154", "北欧");
    namesMap.put("155", "西欧");
    namesMap.put("419", "拉丁美洲");
    namesMap.put("AC", "阿森松岛");
    namesMap.put("AD", "安道尔");
    namesMap.put("AE", "阿拉伯联合酋长国");
    namesMap.put("AF", "阿富汗");
    namesMap.put("AG", "安提瓜和巴布达");
    namesMap.put("AI", "安圭拉");
    namesMap.put("AL", "阿尔巴尼亚");
    namesMap.put("AM", "亚美尼亚");
    namesMap.put("AN", "荷属安的列斯群岛");
    namesMap.put("AO", "安哥拉");
    namesMap.put("AQ", "南极洲");
    namesMap.put("AR", "阿根廷");
    namesMap.put("AS", "美属萨摩亚");
    namesMap.put("AT", "奥地利");
    namesMap.put("AU", "澳大利亚");
    namesMap.put("AW", "阿鲁巴");
    namesMap.put("AX", "奥兰群岛");
    namesMap.put("AZ", "阿塞拜疆");
    namesMap.put("BA", "波斯尼亚和黑塞哥维那");
    namesMap.put("BB", "巴巴多斯");
    namesMap.put("BD", "孟加拉国");
    namesMap.put("BE", "比利时");
    namesMap.put("BF", "布基纳法索");
    namesMap.put("BG", "保加利亚");
    namesMap.put("BH", "巴林");
    namesMap.put("BI", "布隆迪");
    namesMap.put("BJ", "贝宁");
    namesMap.put("BL", "圣巴泰勒米");
    namesMap.put("BM", "百慕大");
    namesMap.put("BN", "文莱");
    namesMap.put("BO", "玻利维亚");
    namesMap.put("BQ", "荷兰加勒比区");
    namesMap.put("BR", "巴西");
    namesMap.put("BS", "巴哈马");
    namesMap.put("BT", "不丹");
    namesMap.put("BV", "布维特岛");
    namesMap.put("BW", "博茨瓦纳");
    namesMap.put("BY", "白俄罗斯");
    namesMap.put("BZ", "伯利兹");
    namesMap.put("CA", "加拿大");
    namesMap.put("CC", "科科斯（基林）群岛");
    namesMap.put("CD", "刚果（金）");
    namesMap.put("CF", "中非共和国");
    namesMap.put("CG", "刚果（布）");
    namesMap.put("CH", "瑞士");
    namesMap.put("CI", "科特迪瓦");
    namesMap.put("CK", "库克群岛");
    namesMap.put("CL", "智利");
    namesMap.put("CM", "喀麦隆");
    namesMap.put("CN", "中国");
    namesMap.put("CO", "哥伦比亚");
    namesMap.put("CP", "克利珀顿岛");
    namesMap.put("CR", "哥斯达黎加");
    namesMap.put("CU", "古巴");
    namesMap.put("CV", "佛得角");
    namesMap.put("CW", "库拉索");
    namesMap.put("CX", "圣诞岛");
    namesMap.put("CY", "塞浦路斯");
    namesMap.put("CZ", "捷克共和国");
    namesMap.put("DE", "德国");
    namesMap.put("DG", "迪戈加西亚岛");
    namesMap.put("DJ", "吉布提");
    namesMap.put("DK", "丹麦");
    namesMap.put("DM", "多米尼克");
    namesMap.put("DO", "多米尼加共和国");
    namesMap.put("DZ", "阿尔及利亚");
    namesMap.put("EA", "休达及梅利利亚");
    namesMap.put("EC", "厄瓜多尔");
    namesMap.put("EE", "爱沙尼亚");
    namesMap.put("EG", "埃及");
    namesMap.put("EH", "西撒哈拉");
    namesMap.put("ER", "厄立特里亚");
    namesMap.put("ES", "西班牙");
    namesMap.put("ET", "埃塞俄比亚");
    namesMap.put("EU", "欧盟");
    namesMap.put("FI", "芬兰");
    namesMap.put("FJ", "斐济");
    namesMap.put("FK", "福克兰群岛");
    namesMap.put("FM", "密克罗尼西亚");
    namesMap.put("FO", "法罗群岛");
    namesMap.put("FR", "法国");
    namesMap.put("GA", "加蓬");
    namesMap.put("GB", "英国");
    namesMap.put("GD", "格林纳达");
    namesMap.put("GE", "格鲁吉亚");
    namesMap.put("GF", "法属圭亚那");
    namesMap.put("GG", "根西岛");
    namesMap.put("GH", "加纳");
    namesMap.put("GI", "直布罗陀");
    namesMap.put("GL", "格陵兰");
    namesMap.put("GM", "冈比亚");
    namesMap.put("GN", "几内亚");
    namesMap.put("GP", "瓜德罗普");
    namesMap.put("GQ", "赤道几内亚");
    namesMap.put("GR", "希腊");
    namesMap.put("GS", "南乔治亚岛和南桑威齐群岛");
    namesMap.put("GT", "危地马拉");
    namesMap.put("GU", "关岛");
    namesMap.put("GW", "几内亚比绍");
    namesMap.put("GY", "圭亚那");
    namesMap.put("HK", "中国香港特别行政区");
    namesMap.put("HM", "赫德岛和麦克唐纳群岛");
    namesMap.put("HN", "洪都拉斯");
    namesMap.put("HR", "克罗地亚");
    namesMap.put("HT", "海地");
    namesMap.put("HU", "匈牙利");
    namesMap.put("IC", "加纳利群岛");
    namesMap.put("ID", "印度尼西亚");
    namesMap.put("IE", "爱尔兰");
    namesMap.put("IL", "以色列");
    namesMap.put("IM", "曼岛");
    namesMap.put("IN", "印度");
    namesMap.put("IO", "英属印度洋领地");
    namesMap.put("IQ", "伊拉克");
    namesMap.put("IR", "伊朗");
    namesMap.put("IS", "冰岛");
    namesMap.put("IT", "意大利");
    namesMap.put("JE", "泽西岛");
    namesMap.put("JM", "牙买加");
    namesMap.put("JO", "约旦");
    namesMap.put("JP", "日本");
    namesMap.put("KE", "肯尼亚");
    namesMap.put("KG", "吉尔吉斯斯坦");
    namesMap.put("KH", "柬埔寨");
    namesMap.put("KI", "基里巴斯");
    namesMap.put("KM", "科摩罗");
    namesMap.put("KN", "圣基茨和尼维斯");
    namesMap.put("KP", "朝鲜");
    namesMap.put("KR", "韩国");
    namesMap.put("KW", "科威特");
    namesMap.put("KY", "开曼群岛");
    namesMap.put("KZ", "哈萨克斯坦");
    namesMap.put("LA", "老挝");
    namesMap.put("LB", "黎巴嫩");
    namesMap.put("LC", "圣卢西亚");
    namesMap.put("LI", "列支敦士登");
    namesMap.put("LK", "斯里兰卡");
    namesMap.put("LR", "利比里亚");
    namesMap.put("LS", "莱索托");
    namesMap.put("LT", "立陶宛");
    namesMap.put("LU", "卢森堡");
    namesMap.put("LV", "拉脱维亚");
    namesMap.put("LY", "利比亚");
    namesMap.put("MA", "摩洛哥");
    namesMap.put("MC", "摩纳哥");
    namesMap.put("MD", "摩尔多瓦");
    namesMap.put("ME", "黑山共和国");
    namesMap.put("MF", "法属圣马丁");
    namesMap.put("MG", "马达加斯加");
    namesMap.put("MH", "马绍尔群岛");
    namesMap.put("MK", "马其顿");
    namesMap.put("ML", "马里");
    namesMap.put("MM", "缅甸");
    namesMap.put("MN", "蒙古");
    namesMap.put("MO", "中国澳门特别行政区");
    namesMap.put("MP", "北马里亚纳群岛");
    namesMap.put("MQ", "马提尼克");
    namesMap.put("MR", "毛里塔尼亚");
    namesMap.put("MS", "蒙特塞拉特");
    namesMap.put("MT", "马耳他");
    namesMap.put("MU", "毛里求斯");
    namesMap.put("MV", "马尔代夫");
    namesMap.put("MW", "马拉维");
    namesMap.put("MX", "墨西哥");
    namesMap.put("MY", "马来西亚");
    namesMap.put("MZ", "莫桑比克");
    namesMap.put("NA", "纳米比亚");
    namesMap.put("NC", "新喀里多尼亚");
    namesMap.put("NE", "尼日尔");
    namesMap.put("NF", "诺福克岛");
    namesMap.put("NG", "尼日利亚");
    namesMap.put("NI", "尼加拉瓜");
    namesMap.put("NL", "荷兰");
    namesMap.put("NO", "挪威");
    namesMap.put("NP", "尼泊尔");
    namesMap.put("NR", "瑙鲁");
    namesMap.put("NU", "纽埃");
    namesMap.put("NZ", "新西兰");
    namesMap.put("OM", "阿曼");
    namesMap.put("PA", "巴拿马");
    namesMap.put("PE", "秘鲁");
    namesMap.put("PF", "法属波利尼西亚");
    namesMap.put("PG", "巴布亚新几内亚");
    namesMap.put("PH", "菲律宾");
    namesMap.put("PK", "巴基斯坦");
    namesMap.put("PL", "波兰");
    namesMap.put("PM", "圣皮埃尔和密克隆群岛");
    namesMap.put("PN", "皮特凯恩群岛");
    namesMap.put("PR", "波多黎各");
    namesMap.put("PS", "巴勒斯坦领土");
    namesMap.put("PT", "葡萄牙");
    namesMap.put("PW", "帕劳");
    namesMap.put("PY", "巴拉圭");
    namesMap.put("QA", "卡塔尔");
    namesMap.put("QO", "大洋洲边远群岛");
    namesMap.put("RE", "留尼汪");
    namesMap.put("RO", "罗马尼亚");
    namesMap.put("RS", "塞尔维亚");
    namesMap.put("RU", "俄罗斯");
    namesMap.put("RW", "卢旺达");
    namesMap.put("SA", "沙特阿拉伯");
    namesMap.put("SB", "所罗门群岛");
    namesMap.put("SC", "塞舌尔");
    namesMap.put("SD", "苏丹");
    namesMap.put("SE", "瑞典");
    namesMap.put("SG", "新加坡");
    namesMap.put("SH", "圣赫勒拿");
    namesMap.put("SI", "斯洛文尼亚");
    namesMap.put("SJ", "斯瓦尔巴特和扬马延");
    namesMap.put("SK", "斯洛伐克");
    namesMap.put("SL", "塞拉利昂");
    namesMap.put("SM", "圣马力诺");
    namesMap.put("SN", "塞内加尔");
    namesMap.put("SO", "索马里");
    namesMap.put("SR", "苏里南");
    namesMap.put("SS", "南苏丹");
    namesMap.put("ST", "圣多美和普林西比");
    namesMap.put("SV", "萨尔瓦多");
    namesMap.put("SX", "荷属圣马丁");
    namesMap.put("SY", "叙利亚");
    namesMap.put("SZ", "斯威士兰");
    namesMap.put("TA", "特里斯坦-达库尼亚群岛");
    namesMap.put("TC", "特克斯和凯科斯群岛");
    namesMap.put("TD", "乍得");
    namesMap.put("TF", "法属南部领地");
    namesMap.put("TG", "多哥");
    namesMap.put("TH", "泰国");
    namesMap.put("TJ", "塔吉克斯坦");
    namesMap.put("TK", "托克劳");
    namesMap.put("TL", "东帝汶");
    namesMap.put("TM", "土库曼斯坦");
    namesMap.put("TN", "突尼斯");
    namesMap.put("TO", "汤加");
    namesMap.put("TR", "土耳其");
    namesMap.put("TT", "特立尼达和多巴哥");
    namesMap.put("TV", "图瓦卢");
    namesMap.put("TW", "台湾");
    namesMap.put("TZ", "坦桑尼亚");
    namesMap.put("UA", "乌克兰");
    namesMap.put("UG", "乌干达");
    namesMap.put("UM", "美国本土外小岛屿");
    namesMap.put("US", "美国");
    namesMap.put("UY", "乌拉圭");
    namesMap.put("UZ", "乌兹别克斯坦");
    namesMap.put("VA", "梵蒂冈");
    namesMap.put("VC", "圣文森特和格林纳丁斯");
    namesMap.put("VE", "委内瑞拉");
    namesMap.put("VG", "英属维京群岛");
    namesMap.put("VI", "美属维京群岛");
    namesMap.put("VN", "越南");
    namesMap.put("VU", "瓦努阿图");
    namesMap.put("WF", "瓦利斯和富图纳");
    namesMap.put("WS", "萨摩亚");
    namesMap.put("XK", "科索沃");
    namesMap.put("YE", "也门");
    namesMap.put("YT", "马约特");
    namesMap.put("ZA", "南非");
    namesMap.put("ZM", "赞比亚");
    namesMap.put("ZW", "津巴布韦");
    namesMap.put("ZZ", "未知地区");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "世界",
        "002": "非洲",
        "003": "北美洲",
        "005": "南美洲",
        "009": "大洋洲",
        "011": "西非",
        "013": "中美洲",
        "014": "东非",
        "015": "北非",
        "017": "中非",
        "018": "南部非洲",
        "019": "美洲",
        "021": "美洲北部",
        "029": "加勒比地区",
        "030": "东亚",
        "034": "南亚",
        "035": "东南亚",
        "039": "南欧",
        "053": "澳大拉西亚",
        "054": "美拉尼西亚",
        "057": "密克罗尼西亚地区",
        "061": "玻利尼西亚",
        "142": "亚洲",
        "143": "中亚",
        "145": "西亚",
        "150": "欧洲",
        "151": "东欧",
        "154": "北欧",
        "155": "西欧",
        "419": "拉丁美洲",
        "AC": "阿森松岛",
        "AD": "安道尔",
        "AE": "阿拉伯联合酋长国",
        "AF": "阿富汗",
        "AG": "安提瓜和巴布达",
        "AI": "安圭拉",
        "AL": "阿尔巴尼亚",
        "AM": "亚美尼亚",
        "AN": "荷属安的列斯群岛",
        "AO": "安哥拉",
        "AQ": "南极洲",
        "AR": "阿根廷",
        "AS": "美属萨摩亚",
        "AT": "奥地利",
        "AU": "澳大利亚",
        "AW": "阿鲁巴",
        "AX": "奥兰群岛",
        "AZ": "阿塞拜疆",
        "BA": "波斯尼亚和黑塞哥维那",
        "BB": "巴巴多斯",
        "BD": "孟加拉国",
        "BE": "比利时",
        "BF": "布基纳法索",
        "BG": "保加利亚",
        "BH": "巴林",
        "BI": "布隆迪",
        "BJ": "贝宁",
        "BL": "圣巴泰勒米",
        "BM": "百慕大",
        "BN": "文莱",
        "BO": "玻利维亚",
        "BQ": "荷兰加勒比区",
        "BR": "巴西",
        "BS": "巴哈马",
        "BT": "不丹",
        "BV": "布维特岛",
        "BW": "博茨瓦纳",
        "BY": "白俄罗斯",
        "BZ": "伯利兹",
        "CA": "加拿大",
        "CC": "科科斯（基林）群岛",
        "CD": "刚果（金）",
        "CF": "中非共和国",
        "CG": "刚果（布）",
        "CH": "瑞士",
        "CI": "科特迪瓦",
        "CK": "库克群岛",
        "CL": "智利",
        "CM": "喀麦隆",
        "CN": "中国",
        "CO": "哥伦比亚",
        "CP": "克利珀顿岛",
        "CR": "哥斯达黎加",
        "CU": "古巴",
        "CV": "佛得角",
        "CW": "库拉索",
        "CX": "圣诞岛",
        "CY": "塞浦路斯",
        "CZ": "捷克共和国",
        "DE": "德国",
        "DG": "迪戈加西亚岛",
        "DJ": "吉布提",
        "DK": "丹麦",
        "DM": "多米尼克",
        "DO": "多米尼加共和国",
        "DZ": "阿尔及利亚",
        "EA": "休达及梅利利亚",
        "EC": "厄瓜多尔",
        "EE": "爱沙尼亚",
        "EG": "埃及",
        "EH": "西撒哈拉",
        "ER": "厄立特里亚",
        "ES": "西班牙",
        "ET": "埃塞俄比亚",
        "EU": "欧盟",
        "FI": "芬兰",
        "FJ": "斐济",
        "FK": "福克兰群岛",
        "FM": "密克罗尼西亚",
        "FO": "法罗群岛",
        "FR": "法国",
        "GA": "加蓬",
        "GB": "英国",
        "GD": "格林纳达",
        "GE": "格鲁吉亚",
        "GF": "法属圭亚那",
        "GG": "根西岛",
        "GH": "加纳",
        "GI": "直布罗陀",
        "GL": "格陵兰",
        "GM": "冈比亚",
        "GN": "几内亚",
        "GP": "瓜德罗普",
        "GQ": "赤道几内亚",
        "GR": "希腊",
        "GS": "南乔治亚岛和南桑威齐群岛",
        "GT": "危地马拉",
        "GU": "关岛",
        "GW": "几内亚比绍",
        "GY": "圭亚那",
        "HK": "中国香港特别行政区",
        "HM": "赫德岛和麦克唐纳群岛",
        "HN": "洪都拉斯",
        "HR": "克罗地亚",
        "HT": "海地",
        "HU": "匈牙利",
        "IC": "加纳利群岛",
        "ID": "印度尼西亚",
        "IE": "爱尔兰",
        "IL": "以色列",
        "IM": "曼岛",
        "IN": "印度",
        "IO": "英属印度洋领地",
        "IQ": "伊拉克",
        "IR": "伊朗",
        "IS": "冰岛",
        "IT": "意大利",
        "JE": "泽西岛",
        "JM": "牙买加",
        "JO": "约旦",
        "JP": "日本",
        "KE": "肯尼亚",
        "KG": "吉尔吉斯斯坦",
        "KH": "柬埔寨",
        "KI": "基里巴斯",
        "KM": "科摩罗",
        "KN": "圣基茨和尼维斯",
        "KP": "朝鲜",
        "KR": "韩国",
        "KW": "科威特",
        "KY": "开曼群岛",
        "KZ": "哈萨克斯坦",
        "LA": "老挝",
        "LB": "黎巴嫩",
        "LC": "圣卢西亚",
        "LI": "列支敦士登",
        "LK": "斯里兰卡",
        "LR": "利比里亚",
        "LS": "莱索托",
        "LT": "立陶宛",
        "LU": "卢森堡",
        "LV": "拉脱维亚",
        "LY": "利比亚",
        "MA": "摩洛哥",
        "MC": "摩纳哥",
        "MD": "摩尔多瓦",
        "ME": "黑山共和国",
        "MF": "法属圣马丁",
        "MG": "马达加斯加",
        "MH": "马绍尔群岛",
        "MK": "马其顿",
        "ML": "马里",
        "MM": "缅甸",
        "MN": "蒙古",
        "MO": "中国澳门特别行政区",
        "MP": "北马里亚纳群岛",
        "MQ": "马提尼克",
        "MR": "毛里塔尼亚",
        "MS": "蒙特塞拉特",
        "MT": "马耳他",
        "MU": "毛里求斯",
        "MV": "马尔代夫",
        "MW": "马拉维",
        "MX": "墨西哥",
        "MY": "马来西亚",
        "MZ": "莫桑比克",
        "NA": "纳米比亚",
        "NC": "新喀里多尼亚",
        "NE": "尼日尔",
        "NF": "诺福克岛",
        "NG": "尼日利亚",
        "NI": "尼加拉瓜",
        "NL": "荷兰",
        "NO": "挪威",
        "NP": "尼泊尔",
        "NR": "瑙鲁",
        "NU": "纽埃",
        "NZ": "新西兰",
        "OM": "阿曼",
        "PA": "巴拿马",
        "PE": "秘鲁",
        "PF": "法属波利尼西亚",
        "PG": "巴布亚新几内亚",
        "PH": "菲律宾",
        "PK": "巴基斯坦",
        "PL": "波兰",
        "PM": "圣皮埃尔和密克隆群岛",
        "PN": "皮特凯恩群岛",
        "PR": "波多黎各",
        "PS": "巴勒斯坦领土",
        "PT": "葡萄牙",
        "PW": "帕劳",
        "PY": "巴拉圭",
        "QA": "卡塔尔",
        "QO": "大洋洲边远群岛",
        "RE": "留尼汪",
        "RO": "罗马尼亚",
        "RS": "塞尔维亚",
        "RU": "俄罗斯",
        "RW": "卢旺达",
        "SA": "沙特阿拉伯",
        "SB": "所罗门群岛",
        "SC": "塞舌尔",
        "SD": "苏丹",
        "SE": "瑞典",
        "SG": "新加坡",
        "SH": "圣赫勒拿",
        "SI": "斯洛文尼亚",
        "SJ": "斯瓦尔巴特和扬马延",
        "SK": "斯洛伐克",
        "SL": "塞拉利昂",
        "SM": "圣马力诺",
        "SN": "塞内加尔",
        "SO": "索马里",
        "SR": "苏里南",
        "SS": "南苏丹",
        "ST": "圣多美和普林西比",
        "SV": "萨尔瓦多",
        "SX": "荷属圣马丁",
        "SY": "叙利亚",
        "SZ": "斯威士兰",
        "TA": "特里斯坦-达库尼亚群岛",
        "TC": "特克斯和凯科斯群岛",
        "TD": "乍得",
        "TF": "法属南部领地",
        "TG": "多哥",
        "TH": "泰国",
        "TJ": "塔吉克斯坦",
        "TK": "托克劳",
        "TL": "东帝汶",
        "TM": "土库曼斯坦",
        "TN": "突尼斯",
        "TO": "汤加",
        "TR": "土耳其",
        "TT": "特立尼达和多巴哥",
        "TV": "图瓦卢",
        "TW": "台湾",
        "TZ": "坦桑尼亚",
        "UA": "乌克兰",
        "UG": "乌干达",
        "UM": "美国本土外小岛屿",
        "US": "美国",
        "UY": "乌拉圭",
        "UZ": "乌兹别克斯坦",
        "VA": "梵蒂冈",
        "VC": "圣文森特和格林纳丁斯",
        "VE": "委内瑞拉",
        "VG": "英属维京群岛",
        "VI": "美属维京群岛",
        "VN": "越南",
        "VU": "瓦努阿图",
        "WF": "瓦利斯和富图纳",
        "WS": "萨摩亚",
        "XK": "科索沃",
        "YE": "也门",
        "YT": "马约特",
        "ZA": "南非",
        "ZM": "赞比亚",
        "ZW": "津巴布韦",
        "ZZ": "未知地区"
    };
  }-*/;
}
