/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FSInfo {
    public static FSInfo instance(Context context) {
        FSInfo instance = context.get(FSInfo.class);
        if (instance == null) {
            instance = new FSInfo();
        }
        return instance;
    }

    protected FSInfo() {
    }

    protected FSInfo(Context context) {
        context.put(FSInfo.class, this);
    }

    public File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public boolean exists(File file) {
        return file.exists();
    }

    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public boolean isFile(File file) {
        return file.isFile();
    }

    public List<File> getJarClassPath(File file) throws IOException {
        String parent = file.getParent();
        try (JarFile jarFile = new JarFile(file);){
            Manifest man = jarFile.getManifest();
            if (man == null) {
                List<File> list = Collections.emptyList();
                return list;
            }
            Attributes attr = man.getMainAttributes();
            if (attr == null) {
                List<File> x2 = Collections.emptyList();
                return x2;
            }
            String path = attr.getValue(Attributes.Name.CLASS_PATH);
            if (path == null) {
                List<File> x2 = Collections.emptyList();
                return x2;
            }
            ArrayList<File> list = new ArrayList<File>();
            StringTokenizer st = new StringTokenizer(path);
            while (st.hasMoreTokens()) {
                String elt = st.nextToken();
                File f = new File(elt);
                if (!f.isAbsolute() && parent != null) {
                    f = new File(parent, elt).getAbsoluteFile();
                }
                list.add(f);
            }
            ArrayList<File> arrayList = list;
            return arrayList;
        }
    }
}

