package com.google.cloud.bigquery;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StandardTableDefinition extends StandardTableDefinition {

  private final TableDefinition.Type type;

  @Nullable
  private final Schema schema;

  @Nullable
  private final Long numBytes;

  @Nullable
  private final Long numLongTermBytes;

  @Nullable
  private final Long numTimeTravelPhysicalBytes;

  @Nullable
  private final Long numTotalLogicalBytes;

  @Nullable
  private final Long numActiveLogicalBytes;

  @Nullable
  private final Long numLongTermLogicalBytes;

  @Nullable
  private final Long numTotalPhysicalBytes;

  @Nullable
  private final Long numActivePhysicalBytes;

  @Nullable
  private final Long numLongTermPhysicalBytes;

  @Nullable
  private final Long numRows;

  @Nullable
  private final String location;

  @Nullable
  private final StandardTableDefinition.StreamingBuffer streamingBuffer;

  @Nullable
  private final TimePartitioning timePartitioning;

  @Nullable
  private final RangePartitioning rangePartitioning;

  @Nullable
  private final Clustering clustering;

  @Nullable
  private final TableConstraints tableConstraints;

  @Nullable
  private final BigLakeConfiguration bigLakeConfiguration;

  private AutoValue_StandardTableDefinition(
      TableDefinition.Type type,
      @Nullable Schema schema,
      @Nullable Long numBytes,
      @Nullable Long numLongTermBytes,
      @Nullable Long numTimeTravelPhysicalBytes,
      @Nullable Long numTotalLogicalBytes,
      @Nullable Long numActiveLogicalBytes,
      @Nullable Long numLongTermLogicalBytes,
      @Nullable Long numTotalPhysicalBytes,
      @Nullable Long numActivePhysicalBytes,
      @Nullable Long numLongTermPhysicalBytes,
      @Nullable Long numRows,
      @Nullable String location,
      @Nullable StandardTableDefinition.StreamingBuffer streamingBuffer,
      @Nullable TimePartitioning timePartitioning,
      @Nullable RangePartitioning rangePartitioning,
      @Nullable Clustering clustering,
      @Nullable TableConstraints tableConstraints,
      @Nullable BigLakeConfiguration bigLakeConfiguration) {
    this.type = type;
    this.schema = schema;
    this.numBytes = numBytes;
    this.numLongTermBytes = numLongTermBytes;
    this.numTimeTravelPhysicalBytes = numTimeTravelPhysicalBytes;
    this.numTotalLogicalBytes = numTotalLogicalBytes;
    this.numActiveLogicalBytes = numActiveLogicalBytes;
    this.numLongTermLogicalBytes = numLongTermLogicalBytes;
    this.numTotalPhysicalBytes = numTotalPhysicalBytes;
    this.numActivePhysicalBytes = numActivePhysicalBytes;
    this.numLongTermPhysicalBytes = numLongTermPhysicalBytes;
    this.numRows = numRows;
    this.location = location;
    this.streamingBuffer = streamingBuffer;
    this.timePartitioning = timePartitioning;
    this.rangePartitioning = rangePartitioning;
    this.clustering = clustering;
    this.tableConstraints = tableConstraints;
    this.bigLakeConfiguration = bigLakeConfiguration;
  }

  @Override
  public TableDefinition.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Nullable
  @Override
  public Long getNumBytes() {
    return numBytes;
  }

  @Nullable
  @Override
  public Long getNumLongTermBytes() {
    return numLongTermBytes;
  }

  @Nullable
  @Override
  public Long getNumTimeTravelPhysicalBytes() {
    return numTimeTravelPhysicalBytes;
  }

  @Nullable
  @Override
  public Long getNumTotalLogicalBytes() {
    return numTotalLogicalBytes;
  }

  @Nullable
  @Override
  public Long getNumActiveLogicalBytes() {
    return numActiveLogicalBytes;
  }

  @Nullable
  @Override
  public Long getNumLongTermLogicalBytes() {
    return numLongTermLogicalBytes;
  }

  @Nullable
  @Override
  public Long getNumTotalPhysicalBytes() {
    return numTotalPhysicalBytes;
  }

  @Nullable
  @Override
  public Long getNumActivePhysicalBytes() {
    return numActivePhysicalBytes;
  }

  @Nullable
  @Override
  public Long getNumLongTermPhysicalBytes() {
    return numLongTermPhysicalBytes;
  }

  @Nullable
  @Override
  public Long getNumRows() {
    return numRows;
  }

  @Nullable
  @Override
  public String getLocation() {
    return location;
  }

  @Nullable
  @Override
  public StandardTableDefinition.StreamingBuffer getStreamingBuffer() {
    return streamingBuffer;
  }

  @Nullable
  @Override
  public TimePartitioning getTimePartitioning() {
    return timePartitioning;
  }

  @Nullable
  @Override
  public RangePartitioning getRangePartitioning() {
    return rangePartitioning;
  }

  @Nullable
  @Override
  public Clustering getClustering() {
    return clustering;
  }

  @Nullable
  @Override
  public TableConstraints getTableConstraints() {
    return tableConstraints;
  }

  @Nullable
  @Override
  public BigLakeConfiguration getBigLakeConfiguration() {
    return bigLakeConfiguration;
  }

  @Override
  public String toString() {
    return "StandardTableDefinition{"
        + "type=" + type + ", "
        + "schema=" + schema + ", "
        + "numBytes=" + numBytes + ", "
        + "numLongTermBytes=" + numLongTermBytes + ", "
        + "numTimeTravelPhysicalBytes=" + numTimeTravelPhysicalBytes + ", "
        + "numTotalLogicalBytes=" + numTotalLogicalBytes + ", "
        + "numActiveLogicalBytes=" + numActiveLogicalBytes + ", "
        + "numLongTermLogicalBytes=" + numLongTermLogicalBytes + ", "
        + "numTotalPhysicalBytes=" + numTotalPhysicalBytes + ", "
        + "numActivePhysicalBytes=" + numActivePhysicalBytes + ", "
        + "numLongTermPhysicalBytes=" + numLongTermPhysicalBytes + ", "
        + "numRows=" + numRows + ", "
        + "location=" + location + ", "
        + "streamingBuffer=" + streamingBuffer + ", "
        + "timePartitioning=" + timePartitioning + ", "
        + "rangePartitioning=" + rangePartitioning + ", "
        + "clustering=" + clustering + ", "
        + "tableConstraints=" + tableConstraints + ", "
        + "bigLakeConfiguration=" + bigLakeConfiguration
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StandardTableDefinition) {
      StandardTableDefinition that = (StandardTableDefinition) o;
      return this.type.equals(that.getType())
          && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()))
          && (this.numBytes == null ? that.getNumBytes() == null : this.numBytes.equals(that.getNumBytes()))
          && (this.numLongTermBytes == null ? that.getNumLongTermBytes() == null : this.numLongTermBytes.equals(that.getNumLongTermBytes()))
          && (this.numTimeTravelPhysicalBytes == null ? that.getNumTimeTravelPhysicalBytes() == null : this.numTimeTravelPhysicalBytes.equals(that.getNumTimeTravelPhysicalBytes()))
          && (this.numTotalLogicalBytes == null ? that.getNumTotalLogicalBytes() == null : this.numTotalLogicalBytes.equals(that.getNumTotalLogicalBytes()))
          && (this.numActiveLogicalBytes == null ? that.getNumActiveLogicalBytes() == null : this.numActiveLogicalBytes.equals(that.getNumActiveLogicalBytes()))
          && (this.numLongTermLogicalBytes == null ? that.getNumLongTermLogicalBytes() == null : this.numLongTermLogicalBytes.equals(that.getNumLongTermLogicalBytes()))
          && (this.numTotalPhysicalBytes == null ? that.getNumTotalPhysicalBytes() == null : this.numTotalPhysicalBytes.equals(that.getNumTotalPhysicalBytes()))
          && (this.numActivePhysicalBytes == null ? that.getNumActivePhysicalBytes() == null : this.numActivePhysicalBytes.equals(that.getNumActivePhysicalBytes()))
          && (this.numLongTermPhysicalBytes == null ? that.getNumLongTermPhysicalBytes() == null : this.numLongTermPhysicalBytes.equals(that.getNumLongTermPhysicalBytes()))
          && (this.numRows == null ? that.getNumRows() == null : this.numRows.equals(that.getNumRows()))
          && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation()))
          && (this.streamingBuffer == null ? that.getStreamingBuffer() == null : this.streamingBuffer.equals(that.getStreamingBuffer()))
          && (this.timePartitioning == null ? that.getTimePartitioning() == null : this.timePartitioning.equals(that.getTimePartitioning()))
          && (this.rangePartitioning == null ? that.getRangePartitioning() == null : this.rangePartitioning.equals(that.getRangePartitioning()))
          && (this.clustering == null ? that.getClustering() == null : this.clustering.equals(that.getClustering()))
          && (this.tableConstraints == null ? that.getTableConstraints() == null : this.tableConstraints.equals(that.getTableConstraints()))
          && (this.bigLakeConfiguration == null ? that.getBigLakeConfiguration() == null : this.bigLakeConfiguration.equals(that.getBigLakeConfiguration()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (schema == null) ? 0 : schema.hashCode();
    h$ *= 1000003;
    h$ ^= (numBytes == null) ? 0 : numBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numLongTermBytes == null) ? 0 : numLongTermBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numTimeTravelPhysicalBytes == null) ? 0 : numTimeTravelPhysicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numTotalLogicalBytes == null) ? 0 : numTotalLogicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numActiveLogicalBytes == null) ? 0 : numActiveLogicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numLongTermLogicalBytes == null) ? 0 : numLongTermLogicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numTotalPhysicalBytes == null) ? 0 : numTotalPhysicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numActivePhysicalBytes == null) ? 0 : numActivePhysicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numLongTermPhysicalBytes == null) ? 0 : numLongTermPhysicalBytes.hashCode();
    h$ *= 1000003;
    h$ ^= (numRows == null) ? 0 : numRows.hashCode();
    h$ *= 1000003;
    h$ ^= (location == null) ? 0 : location.hashCode();
    h$ *= 1000003;
    h$ ^= (streamingBuffer == null) ? 0 : streamingBuffer.hashCode();
    h$ *= 1000003;
    h$ ^= (timePartitioning == null) ? 0 : timePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (rangePartitioning == null) ? 0 : rangePartitioning.hashCode();
    h$ *= 1000003;
    h$ ^= (clustering == null) ? 0 : clustering.hashCode();
    h$ *= 1000003;
    h$ ^= (tableConstraints == null) ? 0 : tableConstraints.hashCode();
    h$ *= 1000003;
    h$ ^= (bigLakeConfiguration == null) ? 0 : bigLakeConfiguration.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 2113445776046717900L;

  @Override
  public StandardTableDefinition.Builder toBuilder() {
    return new AutoValue_StandardTableDefinition.Builder(this);
  }

  static final class Builder extends StandardTableDefinition.Builder {
    private TableDefinition.Type type;
    private Schema schema;
    private Long numBytes;
    private Long numLongTermBytes;
    private Long numTimeTravelPhysicalBytes;
    private Long numTotalLogicalBytes;
    private Long numActiveLogicalBytes;
    private Long numLongTermLogicalBytes;
    private Long numTotalPhysicalBytes;
    private Long numActivePhysicalBytes;
    private Long numLongTermPhysicalBytes;
    private Long numRows;
    private String location;
    private StandardTableDefinition.StreamingBuffer streamingBuffer;
    private TimePartitioning timePartitioning;
    private RangePartitioning rangePartitioning;
    private Clustering clustering;
    private TableConstraints tableConstraints;
    private BigLakeConfiguration bigLakeConfiguration;
    Builder() {
    }
    Builder(StandardTableDefinition source) {
      this.type = source.getType();
      this.schema = source.getSchema();
      this.numBytes = source.getNumBytes();
      this.numLongTermBytes = source.getNumLongTermBytes();
      this.numTimeTravelPhysicalBytes = source.getNumTimeTravelPhysicalBytes();
      this.numTotalLogicalBytes = source.getNumTotalLogicalBytes();
      this.numActiveLogicalBytes = source.getNumActiveLogicalBytes();
      this.numLongTermLogicalBytes = source.getNumLongTermLogicalBytes();
      this.numTotalPhysicalBytes = source.getNumTotalPhysicalBytes();
      this.numActivePhysicalBytes = source.getNumActivePhysicalBytes();
      this.numLongTermPhysicalBytes = source.getNumLongTermPhysicalBytes();
      this.numRows = source.getNumRows();
      this.location = source.getLocation();
      this.streamingBuffer = source.getStreamingBuffer();
      this.timePartitioning = source.getTimePartitioning();
      this.rangePartitioning = source.getRangePartitioning();
      this.clustering = source.getClustering();
      this.tableConstraints = source.getTableConstraints();
      this.bigLakeConfiguration = source.getBigLakeConfiguration();
    }
    @Override
    public StandardTableDefinition.Builder setType(TableDefinition.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumBytes(Long numBytes) {
      this.numBytes = numBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumLongTermBytes(Long numLongTermBytes) {
      this.numLongTermBytes = numLongTermBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumTimeTravelPhysicalBytes(Long numTimeTravelPhysicalBytes) {
      this.numTimeTravelPhysicalBytes = numTimeTravelPhysicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumTotalLogicalBytes(Long numTotalLogicalBytes) {
      this.numTotalLogicalBytes = numTotalLogicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumActiveLogicalBytes(Long numActiveLogicalBytes) {
      this.numActiveLogicalBytes = numActiveLogicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumLongTermLogicalBytes(Long numLongTermLogicalBytes) {
      this.numLongTermLogicalBytes = numLongTermLogicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumTotalPhysicalBytes(Long numTotalPhysicalBytes) {
      this.numTotalPhysicalBytes = numTotalPhysicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumActivePhysicalBytes(Long numActivePhysicalBytes) {
      this.numActivePhysicalBytes = numActivePhysicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumLongTermPhysicalBytes(Long numLongTermPhysicalBytes) {
      this.numLongTermPhysicalBytes = numLongTermPhysicalBytes;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setNumRows(Long numRows) {
      this.numRows = numRows;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setLocation(String location) {
      this.location = location;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setStreamingBuffer(StandardTableDefinition.StreamingBuffer streamingBuffer) {
      this.streamingBuffer = streamingBuffer;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setTimePartitioning(TimePartitioning timePartitioning) {
      this.timePartitioning = timePartitioning;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setRangePartitioning(RangePartitioning rangePartitioning) {
      this.rangePartitioning = rangePartitioning;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setClustering(Clustering clustering) {
      this.clustering = clustering;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setTableConstraints(TableConstraints tableConstraints) {
      this.tableConstraints = tableConstraints;
      return this;
    }
    @Override
    public StandardTableDefinition.Builder setBigLakeConfiguration(BigLakeConfiguration bigLakeConfiguration) {
      this.bigLakeConfiguration = bigLakeConfiguration;
      return this;
    }
    @Override
    public StandardTableDefinition build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StandardTableDefinition(
          this.type,
          this.schema,
          this.numBytes,
          this.numLongTermBytes,
          this.numTimeTravelPhysicalBytes,
          this.numTotalLogicalBytes,
          this.numActiveLogicalBytes,
          this.numLongTermLogicalBytes,
          this.numTotalPhysicalBytes,
          this.numActivePhysicalBytes,
          this.numLongTermPhysicalBytes,
          this.numRows,
          this.location,
          this.streamingBuffer,
          this.timePartitioning,
          this.rangePartitioning,
          this.clustering,
          this.tableConstraints,
          this.bigLakeConfiguration);
    }
  }

}
