/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonDirectCallable;
import com.google.api.gax.httpjson.HttpJsonExceptionCallable;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;

@BetaApi
public class HttpJsonCallableFactory {
    private HttpJsonCallableFactory() {
    }

    private static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createDirectUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings) {
        return new HttpJsonDirectCallable<RequestT, ResponseT>(httpJsonCallSettings.getMethodDescriptor());
    }

    static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable callable = new HttpJsonExceptionCallable(innerCallable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, (ClientContext)clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> innerCallable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        return HttpJsonCallableFactory.createUnaryCallable(innerCallable, callSettings, clientContext);
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, pagedCallSettings, clientContext);
        UnaryCallable pagedCallable = Callables.paged(callable, pagedCallSettings);
        return pagedCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBatchingCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        UnaryCallable callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, batchingCallSettings, clientContext);
        callable = Callables.batching(callable, batchingCallSettings, (ClientContext)clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }
}

