/*
 * Decompiled with CFR 0.152.
 */
package tray.linux;

import java.awt.Point;
import java.awt.TrayIcon;
import jni.utils.JniUtils;
import tray.balloon.Balloon;
import tray.linux.NativeTray;

class NativeLinuxTray
implements NativeTray {
    public NativeLinuxTray() {
        String libraryName = String.format("linuxtray_%s", this.getArchSuffix());
        JniUtils.loadLibrary((String)libraryName);
        this.nativeInit0();
    }

    private String getArchSuffix() {
        if (System.getProperty("os.arch").contains("64")) {
            return "x64";
        }
        return "x86";
    }

    @Override
    public int nativeCreateTrayIcon(String file, String tooltip) {
        return this.nativeCreateTrayIcon0(file, tooltip);
    }

    @Override
    public void nativeAddMenuItem(int nativeId, int menuItemIndex, String caption) {
        this.nativeAddMenuItem0(nativeId, menuItemIndex, caption);
    }

    @Override
    public void nativeSetAutosize(int nativeId, boolean autosize) {
    }

    @Override
    public void nativeDisplayMessage(int nativeId, String caption, String text, TrayIcon.MessageType messageType) {
        Point loc = this.nativeGetIconLocation0(nativeId);
        Balloon balloon = new Balloon();
        balloon.setBounds(loc.x + 12, loc.y + 12, 1, 1);
        balloon.display(caption, text, messageType);
    }

    @Override
    public void nativeSetImage(int nativeId, String file) {
        this.nativeSetImage0(nativeId, file);
    }

    @Override
    public void nativeRemoveMe(int nativeId) {
        this.nativeRemoveMe0(nativeId);
    }

    private native void nativeInit0();

    private native int nativeCreateTrayIcon0(String var1, String var2);

    private native void nativeRemoveMe0(int var1);

    private native void nativeAddMenuItem0(int var1, int var2, String var3);

    private native void nativeSetImage0(int var1, String var2);

    private native Point nativeGetIconLocation0(int var1);
}

