/*
 * Decompiled with CFR 0.152.
 */
package com.github.slavaz.maven.plugin.postgresql.embedded.psql.util;

import com.github.slavaz.maven.plugin.postgresql.embedded.psql.IPgInstanceProcessData;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.PgVersion;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.util.CharsetParameterList;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.util.Collection;
import ru.yandex.qatools.embed.postgresql.config.AbstractPostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;

public class PostgresConfigUtil {
    public static PostgresConfig get(IPgInstanceProcessData pgInstanceProcessData) throws IOException {
        AbstractPostgresConfig.Storage storage = PostgresConfigUtil.getStorage(pgInstanceProcessData);
        AbstractPostgresConfig.Credentials creds = PostgresConfigUtil.getCredentials(pgInstanceProcessData);
        IVersion version = PostgresConfigUtil.getVersion(pgInstanceProcessData);
        PostgresConfig config = PostgresConfigUtil.getConfig(pgInstanceProcessData, storage, creds, version);
        config.getAdditionalInitDbParams().addAll(PostgresConfigUtil.getCharsetParameters(pgInstanceProcessData));
        return config;
    }

    private static Collection<String> getCharsetParameters(IPgInstanceProcessData pgInstanceProcessData) {
        return new CharsetParameterList(pgInstanceProcessData).get();
    }

    private static PostgresConfig getConfig(IPgInstanceProcessData pgInstanceProcessData, AbstractPostgresConfig.Storage storage, AbstractPostgresConfig.Credentials creds, IVersion version) throws IOException {
        return new PostgresConfig(version, PostgresConfigUtil.getNet(pgInstanceProcessData), storage, new AbstractPostgresConfig.Timeout(), creds);
    }

    private static AbstractPostgresConfig.Credentials getCredentials(IPgInstanceProcessData pgInstanceProcessData) {
        return new AbstractPostgresConfig.Credentials(pgInstanceProcessData.getUserName(), pgInstanceProcessData.getPassword());
    }

    private static AbstractPostgresConfig.Storage getStorage(IPgInstanceProcessData pgInstanceProcessData) throws IOException {
        return new AbstractPostgresConfig.Storage(pgInstanceProcessData.getDbName(), pgInstanceProcessData.getPgDatabaseDir());
    }

    private static IVersion getVersion(IPgInstanceProcessData pgInstanceProcessData) {
        return PgVersion.get(pgInstanceProcessData.getPgServerVersion());
    }

    private static AbstractPostgresConfig.Net getNet(IPgInstanceProcessData pgInstanceProcessData) throws IOException {
        String host = "".equals(pgInstanceProcessData.getPgHost()) ? Network.getLocalHost().getHostAddress() : pgInstanceProcessData.getPgHost();
        return new AbstractPostgresConfig.Net(host, pgInstanceProcessData.getPgPort());
    }
}

