/*
 * Decompiled with CFR 0.152.
 */
package com.github.slavaz.maven.plugin.postgresql.embedded.goals;

import com.github.slavaz.maven.plugin.postgresql.embedded.classloader.ClassLoaderHolder;
import com.github.slavaz.maven.plugin.postgresql.embedded.goals.AbstractGoalMojo;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.IsolatedPgInstanceManager;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="stop")
public class StopGoalMojo
extends AbstractGoalMojo {
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Optional<ClassLoader> classLoader = ClassLoaderHolder.getClassLoader();
        if (classLoader.isPresent()) {
            try {
                this.getLog().info((CharSequence)"Stopping PostgreSQL...");
                new IsolatedPgInstanceManager(classLoader.get()).stop();
                this.getLog().debug((CharSequence)"PostgreSQL stopped.");
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Failed to stop PostgreSQL", (Throwable)e);
            }
        } else {
            this.getLog().warn((CharSequence)"PostgreSQL was not started");
        }
    }
}

