/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

import blogspot.software_and_algorithms.stern_library.data_structure.RedBlackTree;
import java.util.Comparator;

public class OrderLinkedRedBlackTree<T>
extends RedBlackTree<T> {
    private RedBlackTree.Node<T> head;

    public OrderLinkedRedBlackTree() {
        this((Comparator<T>)null);
    }

    public OrderLinkedRedBlackTree(Comparator<T> comparator) {
        super(comparator);
    }

    @Override
    public void clear() {
        super.clear();
        this.head = null;
    }

    @Override
    protected RedBlackTree.Node<T> createNewNode(T value) {
        return new Node<T>(value);
    }

    @Override
    public RedBlackTree.Node<T> delete(T value) {
        RedBlackTree.Node<T> result;
        if (this.head != null && this.head.getValue().equals(value)) {
            this.head = this.getSuccessor(this.head);
        }
        if ((result = super.delete(value)) != null) {
            Node linkedNode = (Node)result;
            if (linkedNode.getPredecessor() != null) {
                linkedNode.getPredecessor().setSuccessor(linkedNode.getSuccessor());
            }
            if (linkedNode.getSuccessor() != null) {
                linkedNode.getSuccessor().setPredecessor(linkedNode.getPredecessor());
            }
        }
        return result;
    }

    @Override
    protected void exchangeValues(RedBlackTree.Node<T> node, RedBlackTree.Node<T> successor) {
        super.exchangeValues(node, successor);
        Node linkedNode = (Node)node;
        Node linkedSuccessor = (Node)successor;
        linkedNode.setSuccessor(linkedSuccessor.getSuccessor());
        if (linkedNode.getSuccessor() != null) {
            linkedNode.getSuccessor().setPredecessor(linkedNode);
        }
        linkedSuccessor.setPredecessor(null);
        linkedSuccessor.setSuccessor(null);
    }

    @Override
    public RedBlackTree.Node<T> getFirstNode() {
        return this.head;
    }

    @Override
    public RedBlackTree.Node<T> getPredecessor(RedBlackTree.Node<T> node) {
        return ((Node)node).getPredecessor();
    }

    @Override
    public RedBlackTree.Node<T> getSuccessor(RedBlackTree.Node<T> node) {
        return ((Node)node).getSuccessor();
    }

    @Override
    public RedBlackTree.Node<T> insert(T value) {
        RedBlackTree.Node<T> result = super.insert(value);
        if (result != null) {
            Node linkedNode = (Node)result;
            Node pred = (Node)super.getPredecessor(result);
            linkedNode.setPredecessor(pred);
            if (pred != null) {
                pred.setSuccessor(linkedNode);
            }
            Node succ = (Node)super.getSuccessor(result);
            linkedNode.setSuccessor(succ);
            if (succ != null) {
                succ.setPredecessor(linkedNode);
            }
            if (this.head == null) {
                this.head = this.getRoot();
            } else {
                RedBlackTree.Node<T> node = this.getPredecessor(this.head);
                if (node != null) {
                    this.head = node;
                }
            }
        }
        return result;
    }

    public static class Node<T>
    extends RedBlackTree.Node<T> {
        private Node<T> predecessor;
        private Node<T> successor;

        public Node(T value) {
            super(value);
        }

        public Node<T> getPredecessor() {
            return this.predecessor;
        }

        public Node<T> getSuccessor() {
            return this.successor;
        }

        protected void setPredecessor(Node<T> node) {
            this.predecessor = node;
        }

        protected void setSuccessor(Node<T> node) {
            this.successor = node;
        }
    }
}

