
package com.github.highcharts4gwt.model.highcharts.option.mock;

import com.github.highcharts4gwt.model.highcharts.option.api.LabelFormatterCallback;
import com.github.highcharts4gwt.model.highcharts.option.api.Legend;
import com.github.highcharts4gwt.model.highcharts.option.api.legend.Navigation;
import com.github.highcharts4gwt.model.highcharts.option.api.legend.Title;


/**
 * The legend is a box containing a symbol and name for each series item
 * 	or point item in the chart.
 * 
 */
public class MockLegend
    implements Legend
{

    private String align;
    private String backgroundColor;
    private String borderColor;
    private double borderRadius;
    private double borderWidth;
    private boolean enabled;
    private boolean floating;
    private double itemDistance;
    private String itemHiddenStyle;
    private String itemHoverStyle;
    private double itemMarginBottom;
    private double itemMarginTop;
    private String itemStyle;
    private double itemWidth;
    private String labelFormat;
    private String layout;
    private double lineHeight;
    private double margin;
    private double maxHeight;
    private Navigation navigation;
    private double padding;
    private boolean reversed;
    private boolean rtl;
    private boolean shadowAsBoolean;
    private String shadowAsJsonString;
    private String style;
    private double symbolHeight;
    private double symbolPadding;
    private double symbolRadius;
    private double symbolWidth;
    private Title title;
    private boolean useHTML;
    private String verticalAlign;
    private double width;
    private double x;
    private double y;
    private String genericField;
    private String functionAsString;

    public String align() {
        return align;
    }

    public MockLegend align(String align) {
        this.align = align;
        return this;
    }

    public String backgroundColor() {
        return backgroundColor;
    }

    public MockLegend backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public String borderColor() {
        return borderColor;
    }

    public MockLegend borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public double borderRadius() {
        return borderRadius;
    }

    public MockLegend borderRadius(double borderRadius) {
        this.borderRadius = borderRadius;
        return this;
    }

    public double borderWidth() {
        return borderWidth;
    }

    public MockLegend borderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public boolean enabled() {
        return enabled;
    }

    public MockLegend enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean floating() {
        return floating;
    }

    public MockLegend floating(boolean floating) {
        this.floating = floating;
        return this;
    }

    public double itemDistance() {
        return itemDistance;
    }

    public MockLegend itemDistance(double itemDistance) {
        this.itemDistance = itemDistance;
        return this;
    }

    public String itemHiddenStyle() {
        return itemHiddenStyle;
    }

    public MockLegend itemHiddenStyle(String itemHiddenStyleAsJsonString) {
        this.itemHiddenStyle = itemHiddenStyleAsJsonString;
        return this;
    }

    public String itemHoverStyle() {
        return itemHoverStyle;
    }

    public MockLegend itemHoverStyle(String itemHoverStyleAsJsonString) {
        this.itemHoverStyle = itemHoverStyleAsJsonString;
        return this;
    }

    public double itemMarginBottom() {
        return itemMarginBottom;
    }

    public MockLegend itemMarginBottom(double itemMarginBottom) {
        this.itemMarginBottom = itemMarginBottom;
        return this;
    }

    public double itemMarginTop() {
        return itemMarginTop;
    }

    public MockLegend itemMarginTop(double itemMarginTop) {
        this.itemMarginTop = itemMarginTop;
        return this;
    }

    public String itemStyle() {
        return itemStyle;
    }

    public MockLegend itemStyle(String itemStyleAsJsonString) {
        this.itemStyle = itemStyleAsJsonString;
        return this;
    }

    public double itemWidth() {
        return itemWidth;
    }

    public MockLegend itemWidth(double itemWidth) {
        this.itemWidth = itemWidth;
        return this;
    }

    public String labelFormat() {
        return labelFormat;
    }

    public MockLegend labelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    public MockLegend labelFormatter(LabelFormatterCallback labelFormatter) {
        return this;
    }

    public String layout() {
        return layout;
    }

    public MockLegend layout(String layout) {
        this.layout = layout;
        return this;
    }

    public double lineHeight() {
        return lineHeight;
    }

    public MockLegend lineHeight(double lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public double margin() {
        return margin;
    }

    public MockLegend margin(double margin) {
        this.margin = margin;
        return this;
    }

    public double maxHeight() {
        return maxHeight;
    }

    public MockLegend maxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Navigation navigation() {
        return navigation;
    }

    public MockLegend navigation(Navigation navigation) {
        this.navigation = navigation;
        return this;
    }

    public double padding() {
        return padding;
    }

    public MockLegend padding(double padding) {
        this.padding = padding;
        return this;
    }

    public boolean reversed() {
        return reversed;
    }

    public MockLegend reversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public boolean rtl() {
        return rtl;
    }

    public MockLegend rtl(boolean rtl) {
        this.rtl = rtl;
        return this;
    }

    public boolean shadowAsBoolean() {
        return shadowAsBoolean;
    }

    public MockLegend shadowAsBoolean(boolean shadowAsBoolean) {
        this.shadowAsBoolean = shadowAsBoolean;
        return this;
    }

    public String shadowAsJsonString() {
        return shadowAsJsonString;
    }

    public MockLegend shadowAsJsonString(String shadowAsJsonString) {
        this.shadowAsJsonString = shadowAsJsonString;
        return this;
    }

    public String style() {
        return style;
    }

    public MockLegend style(String styleAsJsonString) {
        this.style = styleAsJsonString;
        return this;
    }

    public double symbolHeight() {
        return symbolHeight;
    }

    public MockLegend symbolHeight(double symbolHeight) {
        this.symbolHeight = symbolHeight;
        return this;
    }

    public double symbolPadding() {
        return symbolPadding;
    }

    public MockLegend symbolPadding(double symbolPadding) {
        this.symbolPadding = symbolPadding;
        return this;
    }

    public double symbolRadius() {
        return symbolRadius;
    }

    public MockLegend symbolRadius(double symbolRadius) {
        this.symbolRadius = symbolRadius;
        return this;
    }

    public double symbolWidth() {
        return symbolWidth;
    }

    public MockLegend symbolWidth(double symbolWidth) {
        this.symbolWidth = symbolWidth;
        return this;
    }

    public Title title() {
        return title;
    }

    public MockLegend title(Title title) {
        this.title = title;
        return this;
    }

    public boolean useHTML() {
        return useHTML;
    }

    public MockLegend useHTML(boolean useHTML) {
        this.useHTML = useHTML;
        return this;
    }

    public String verticalAlign() {
        return verticalAlign;
    }

    public MockLegend verticalAlign(String verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public double width() {
        return width;
    }

    public MockLegend width(double width) {
        this.width = width;
        return this;
    }

    public double x() {
        return x;
    }

    public MockLegend x(double x) {
        this.x = x;
        return this;
    }

    public double y() {
        return y;
    }

    public MockLegend y(double y) {
        this.y = y;
        return this;
    }

    public String getFieldAsJsonObject(String fieldName) {
        return genericField;
    }

    public MockLegend setFieldAsJsonObject(String fieldName, String fieldValueAsJsonObject) {
        this.genericField = fieldValueAsJsonObject;
        return this;
    }

    public String getFunctionAsString(String fieldName) {
        return functionAsString;
    }

    public MockLegend setFunctionAsString(String fieldName, String functionAsString) {
        this.functionAsString = functionAsString;
        return this;
    }

}
