
package com.github.highcharts4gwt.model.highcharts.option.api.plotoptions.solidgauge;

import com.github.highcharts4gwt.model.highcharts.option.api.plotoptions.solidgauge.FormatterCallback;


/**
 * Data labels for the gauge. For gauges, the data labels are enabled by default and shown in a bordered box below the point.
 * 
 */
public interface DataLabels {


    /**
     * The alignment of the data label compared to the point.  If <code>right</code>, the right side of the label should be touching the point. For points with an extent, like columns, the alignments also dictates how to align it inside the box, as given with the <a href="#plotOptions.column.dataLabels.inside">inside</a> option. Can be one of "left", "center" or "right".
     * 
     */
    String align();

    /**
     * The alignment of the data label compared to the point.  If <code>right</code>, the right side of the label should be touching the point. For points with an extent, like columns, the alignments also dictates how to align it inside the box, as given with the <a href="#plotOptions.column.dataLabels.inside">inside</a> option. Can be one of "left", "center" or "right".
     * 
     */
    DataLabels align(String align);

    /**
     * Whether to allow data labels to overlap. To make the labels less sensitive for overlapping, the <a href="#plotOptions.series.dataLabels.padding">dataLabels.padding</a> can be set to 0.
     * 
     */
    boolean allowOverlap();

    /**
     * Whether to allow data labels to overlap. To make the labels less sensitive for overlapping, the <a href="#plotOptions.series.dataLabels.padding">dataLabels.padding</a> can be set to 0.
     * 
     */
    DataLabels allowOverlap(boolean allowOverlap);

    /**
     * The background color or gradient for the data label. Defaults to <code>undefined</code>.
     * 
     */
    String backgroundColor();

    /**
     * The background color or gradient for the data label. Defaults to <code>undefined</code>.
     * 
     */
    DataLabels backgroundColor(String backgroundColor);

    /**
     * The border color for the data label.
     * 
     */
    String borderColor();

    /**
     * The border color for the data label.
     * 
     */
    DataLabels borderColor(String borderColor);

    /**
     * The border radius in pixels for the gauge's data label.
     * 
     */
    double borderRadius();

    /**
     * The border radius in pixels for the gauge's data label.
     * 
     */
    DataLabels borderRadius(double borderRadius);

    /**
     * The border width in pixels for the gauge data label.
     * 
     */
    double borderWidth();

    /**
     * The border width in pixels for the gauge data label.
     * 
     */
    DataLabels borderWidth(double borderWidth);

    /**
     * The text color for the data labels. Defaults to <code>null</code>.
     * 
     */
    String color();

    /**
     * The text color for the data labels. Defaults to <code>null</code>.
     * 
     */
    DataLabels color(String color);

    /**
     * Whether to hide data labels that are outside the plot area. By default, the data label is moved inside the plot area according to the <a href="#plotOptions.series.dataLabels.overflow">overflow</a> option.
     * 
     */
    boolean crop();

    /**
     * Whether to hide data labels that are outside the plot area. By default, the data label is moved inside the plot area according to the <a href="#plotOptions.series.dataLabels.overflow">overflow</a> option.
     * 
     */
    DataLabels crop(boolean crop);

    /**
     * Whether to defer displaying the data labels until the initial series animation has finished.
     * 
     */
    boolean defer();

    /**
     * Whether to defer displaying the data labels until the initial series animation has finished.
     * 
     */
    DataLabels defer(boolean defer);

    /**
     * Enable or disable the data labels.
     * 
     */
    boolean enabled();

    /**
     * Enable or disable the data labels.
     * 
     */
    DataLabels enabled(boolean enabled);

    /**
     * A <a href="http://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting">format string</a> for the data label. Available variables are the same as for <code>formatter</code>.
     * 
     */
    String format();

    /**
     * A <a href="http://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting">format string</a> for the data label. Available variables are the same as for <code>formatter</code>.
     * 
     */
    DataLabels format(String format);

    /**
     * Callback JavaScript function to format the data label. Note that if a <code>format</code> is defined, the format takes precedence and the formatter is ignored. Available data are:
     * <table>
     * <tbody><tr>
     *   <td><code>this.percentage</code></td>
     *   <td>Stacked series and pies only. The point's percentage of the total.</td>
     * </tr>
     * <tr>
     *   <td><code>this.point</code></td>
     *   <td>The point object. The point name, if defined, is available 
     * through <code>this.point.name</code>.</td>
     * </tr>
     * <tr>
     *   <td><code>this.series</code>:</td>
     *   <td>The series object. The series name is available 
     * through <code>this.series.name</code>.</td>
     * </tr>
     * <tr>
     *   <td><code>this.total</code></td>
     *   <td>Stacked series only. The total value at this point's x value.</td>
     * </tr>				
     * <tr>
     *   <td><code>this.x</code>:</td>
     *   <td>The x value.</td>
     * </tr>
     * <tr>
     *   <td><code>this.y</code>:</td>
     *   <td>The y value.</td>
     * </tr>
     * </tbody></table>
     * 
     */
    DataLabels formatter(FormatterCallback formatter);

    /**
     * For points with an extent, like columns, whether to align the data label inside the box or to the actual value point. Defaults to <code>false</code> in most cases, <code>true</code> in stacked columns.
     * 
     */
    boolean inside();

    /**
     * For points with an extent, like columns, whether to align the data label inside the box or to the actual value point. Defaults to <code>false</code> in most cases, <code>true</code> in stacked columns.
     * 
     */
    DataLabels inside(boolean inside);

    /**
     * How to handle data labels that flow outside the plot area. The default is <code>justify</code>, which aligns them inside the plot area. For columns and bars, this means it will be moved inside the bar. To display data labels outside the plot area, set <code>crop</code> to <code>false</code> and <code>overflow</code> to <code>"none"</code>.
     * 
     */
    String overflow();

    /**
     * How to handle data labels that flow outside the plot area. The default is <code>justify</code>, which aligns them inside the plot area. For columns and bars, this means it will be moved inside the bar. To display data labels outside the plot area, set <code>crop</code> to <code>false</code> and <code>overflow</code> to <code>"none"</code>.
     * 
     */
    DataLabels overflow(String overflow);

    /**
     * When either the <code>borderWidth</code> or the <code>backgroundColor</code> is set, this		is the padding within the box.
     * 
     */
    double padding();

    /**
     * When either the <code>borderWidth</code> or the <code>backgroundColor</code> is set, this		is the padding within the box.
     * 
     */
    DataLabels padding(double padding);

    /**
     * Text rotation in degrees. Note that due to a more complex structure, backgrounds, borders and padding will be lost on a rotated data label.
     * 
     */
    double rotation();

    /**
     * Text rotation in degrees. Note that due to a more complex structure, backgrounds, borders and padding will be lost on a rotated data label.
     * 
     */
    DataLabels rotation(double rotation);

    /**
     * The shadow of the box. Works best with <code>borderWidth</code> or <code>backgroundColor</code>. Since 2.3 the shadow can be an object configuration containing <code>color</code>, <code>offsetX</code>, <code>offsetY</code>, <code>opacity</code> and <code>width</code>.
     * 
     */
    boolean shadowAsBoolean();

    /**
     * The shadow of the box. Works best with <code>borderWidth</code> or <code>backgroundColor</code>. Since 2.3 the shadow can be an object configuration containing <code>color</code>, <code>offsetX</code>, <code>offsetY</code>, <code>opacity</code> and <code>width</code>.
     * 
     */
    DataLabels shadowAsBoolean(boolean shadowAsBoolean);

    /**
     * The shadow of the box. Works best with <code>borderWidth</code> or <code>backgroundColor</code>. Since 2.3 the shadow can be an object configuration containing <code>color</code>, <code>offsetX</code>, <code>offsetY</code>, <code>opacity</code> and <code>width</code>.
     * 
     */
    String shadowAsJsonString();

    /**
     * The shadow of the box. Works best with <code>borderWidth</code> or <code>backgroundColor</code>. Since 2.3 the shadow can be an object configuration containing <code>color</code>, <code>offsetX</code>, <code>offsetY</code>, <code>opacity</code> and <code>width</code>.
     * 
     */
    DataLabels shadowAsJsonString(String shadowAsJsonString);

    /**
     * The name of a symbol to use for the border around the label. Symbols are predefined functions on the Renderer object.
     * 
     */
    String shape();

    /**
     * The name of a symbol to use for the border around the label. Symbols are predefined functions on the Renderer object.
     * 
     */
    DataLabels shape(String shape);

    /**
     * Styles for the label.
     * 
     */
    String style();

    /**
     * Styles for the label.
     * 
     */
    DataLabels style(String styleAsJsonString);

    /**
     * Whether to <a href="http://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html">use HTML</a> to render the labels.
     * 
     */
    boolean useHTML();

    /**
     * Whether to <a href="http://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html">use HTML</a> to render the labels.
     * 
     */
    DataLabels useHTML(boolean useHTML);

    /**
     * The vertical alignment of the data label.
     * 
     */
    String verticalAlign();

    /**
     * The vertical alignment of the data label.
     * 
     */
    DataLabels verticalAlign(String verticalAlign);

    /**
     * The x position offset of the label relative to the point.
     * 
     */
    double x();

    /**
     * The x position offset of the label relative to the point.
     * 
     */
    DataLabels x(double x);

    /**
     * The y position offset of the label relative to the center of the gauge.
     * 
     */
    double y();

    /**
     * The y position offset of the label relative to the center of the gauge.
     * 
     */
    DataLabels y(double y);

    /**
     * The Z index of the data labels. A value of 2 display them behind the dial.
     * 
     */
    double zIndex();

    /**
     * The Z index of the data labels. A value of 2 display them behind the dial.
     * 
     */
    DataLabels zIndex(double zIndex);

    String getFieldAsJsonObject(String fieldName);

    DataLabels setFieldAsJsonObject(String fieldName, String fieldValueAsJonObject);

    String getFunctionAsString(String fieldName);

    DataLabels setFunctionAsString(String fieldName, String functionAsString);

}
