/*
 * Decompiled with CFR 0.152.
 */
package smile.data.measure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.DataTypes;

public abstract class DiscreteMeasure
implements Measure {
    final int[] values;
    final String[] levels;
    final Map<Number, String> value2level;
    final Map<String, Number> level2value;

    public DiscreteMeasure(String ... levels) {
        this(IntStream.range(0, levels.length).toArray(), levels);
    }

    public DiscreteMeasure(List<String> levels) {
        this(levels.toArray(new String[levels.size()]));
    }

    public DiscreteMeasure(int[] values, String[] levels) {
        if (values.length != levels.length) {
            throw new IllegalArgumentException("The size of values and levels don't match");
        }
        this.values = values;
        this.levels = levels;
        this.value2level = new HashMap<Number, String>();
        this.level2value = new HashMap<String, Number>();
        if (levels.length <= 128) {
            for (int i = 0; i < values.length; ++i) {
                this.value2level.put(values[i], levels[i]);
                this.level2value.put(levels[i], (byte)values[i]);
            }
        } else if (levels.length <= 32768) {
            for (int i = 0; i < values.length; ++i) {
                this.value2level.put(values[i], levels[i]);
                this.level2value.put(levels[i], (short)values[i]);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.value2level.put(values[i], levels[i]);
                this.level2value.put(levels[i], values[i]);
            }
        }
    }

    static int[] values(Class<? extends Enum> clazz) {
        return Arrays.stream(clazz.getEnumConstants()).mapToInt(e -> e.ordinal()).toArray();
    }

    static String[] levels(Class<? extends Enum> clazz) {
        return (String[])Arrays.stream(clazz.getEnumConstants()).map(Object::toString).toArray(String[]::new);
    }

    public int size() {
        return this.levels.length;
    }

    public int[] values() {
        return this.values;
    }

    public String[] levels() {
        return this.levels;
    }

    public String level(int i) {
        return this.value2level.get(i);
    }

    public DataType type() {
        if (this.levels.length <= 128) {
            return DataTypes.ByteType;
        }
        if (this.levels.length <= 32768) {
            return DataTypes.ShortType;
        }
        return DataTypes.IntegerType;
    }

    public String toString(int level) {
        return this.level(level);
    }

    @Override
    public String toString(Object o) {
        return this.level(((Number)o).intValue());
    }

    @Override
    public Number valueOf(String s) {
        return this.level2value.get(s);
    }

    public boolean equals(Object o) {
        if (o instanceof DiscreteMeasure) {
            DiscreteMeasure measure = (DiscreteMeasure)o;
            return Arrays.equals(this.levels, measure.levels) && Arrays.equals(this.values, this.values);
        }
        return false;
    }
}

