/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import smile.data.Tuple;
import smile.data.formula.AbstractTerm;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructType;

public abstract class Operator
extends AbstractTerm {
    String name;
    Term a;
    Term b;
    DataType type;
    Function<Tuple, Object> lambda;

    public Operator(String name, Term a, Term b) {
        this.name = name;
        this.a = a;
        this.b = b;
    }

    @Override
    public String name() {
        return String.format("%s %s %s", this.a.name(), this.name, this.b.name());
    }

    @Override
    public DataType type() {
        return this.type;
    }

    public String toString() {
        return String.format("(%s)", this.name());
    }

    @Override
    public Set<String> variables() {
        HashSet<String> vars = new HashSet<String>(this.a.variables());
        vars.addAll(this.b.variables());
        return vars;
    }

    @Override
    public Object apply(Tuple o) {
        Object x = this.a.apply(o);
        Object y = this.b.apply(o);
        if (x == null || y == null) {
            return null;
        }
        return this.lambda.apply(o);
    }

    @Override
    public void bind(StructType schema) {
        this.a.bind(schema);
        this.b.bind(schema);
        this.type = DataType.prompt(this.a.type(), this.b.type());
    }
}

