/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.Collections;
import java.util.Set;
import smile.data.Tuple;
import smile.data.formula.AbstractTerm;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructType;

class OneHotEncoder
extends AbstractTerm {
    final String name;
    final int column;
    final int value;
    final String level;

    public OneHotEncoder(String name, int column, int value, String level) {
        this.name = name;
        this.column = column;
        this.value = value;
        this.level = level;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Set<String> variables() {
        return Collections.singleton(this.name);
    }

    @Override
    public Object apply(Tuple o) {
        return this.applyAsByte(o);
    }

    @Override
    public byte applyAsByte(Tuple o) {
        return this.value == ((Number)o.get(this.column)).intValue() ? (byte)1 : 0;
    }

    @Override
    public String name() {
        return String.format("%s_%s", this.name, this.level);
    }

    @Override
    public DataType type() {
        return DataTypes.ByteType;
    }

    @Override
    public void bind(StructType schema) {
    }
}

