/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Spliterator;
import java.util.function.Consumer;
import smile.data.Dataset;

class DatasetSpliterator<T>
implements Spliterator<T> {
    private Dataset<T> data;
    private int characteristics = 17472;
    private int origin;
    private final int fence;

    public DatasetSpliterator(Dataset<T> data, int additionalCharacteristics) {
        if (data.distributed()) {
            throw new UnsupportedOperationException("The LocalDatasetSpliterator is applied to a distributed Dataset.");
        }
        this.data = data;
        this.characteristics |= additionalCharacteristics;
        this.origin = 0;
        this.fence = data.size();
    }

    public DatasetSpliterator(DatasetSpliterator<T> spliterator, int origin, int fence) {
        this.data = spliterator.data;
        this.characteristics = spliterator.characteristics;
        this.origin = origin;
        this.fence = fence;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.origin < this.fence) {
            action.accept(this.data.get(this.origin));
            ++this.origin;
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        int lo = this.origin;
        int mid = lo + this.fence >>> 1;
        if (lo < mid) {
            this.origin = mid;
            return new DatasetSpliterator<T>(this, lo, mid);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.origin;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

