/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class HtmlCharacter {
    static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String PROPERTIES_FILE = "HtmlCharacterEntityReferences.properties";
    private static final char REFERENCE_START = '&';
    private static final char REFERENCE_END = ';';
    private final String[] characterToEntityReferenceMap = new String[3000];
    private final Map<String, Character> entityReferenceToCharacterMap = new HashMap<String, Character>(512);

    public HtmlCharacter() {
        Properties entityReferences = new Properties();
        InputStream is = HtmlCharacter.class.getResourceAsStream(PROPERTIES_FILE);
        if (is == null) {
            throw new IllegalStateException("Cannot find reference definition file [HtmlCharacterEntityReferences.properties] as class path resource");
        }
        try {
            try {
                entityReferences.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to parse reference definition file [HtmlCharacterEntityReferences.properties]: " + ex.getMessage());
        }
        Enumeration<?> keys = entityReferences.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            int referredChar = Integer.parseInt(key);
            int index = referredChar < 1000 ? referredChar : referredChar - 7000;
            String reference = entityReferences.getProperty(key);
            this.characterToEntityReferenceMap[index] = '&' + reference + ';';
            this.entityReferenceToCharacterMap.put(reference, Character.valueOf((char)referredChar));
        }
    }

    public String escape(char character) {
        return this.escape(character, DEFAULT_ENCODING);
    }

    public String escape(char character, String encoding) {
        int index;
        String entityReference;
        if (encoding.startsWith("UTF-")) {
            switch (character) {
                case 60: {
                    return "&lt;";
                }
                case 62: {
                    return "&gt;";
                }
                case 34: {
                    return "&quot;";
                }
                case 38: {
                    return "&amp;";
                }
                case 39: {
                    return "&#39;";
                }
            }
            return null;
        }
        if ((character < 1000 || character >= 8000 && character < 10000) && (entityReference = this.characterToEntityReferenceMap[index = character < 1000 ? character : character - 7000]) != null) {
            return entityReference;
        }
        return null;
    }
}

