/*
 * Decompiled with CFR 0.152.
 */
package smile.hash;

import java.nio.ByteBuffer;
import smile.hash.MurmurHash2;

public interface SimHash<T> {
    public long hash(T var1);

    public static SimHash<int[]> of(byte[][] features) {
        int n = features.length;
        long[] hash = new long[n];
        for (int i = 0; i < n; ++i) {
            ByteBuffer buffer = ByteBuffer.wrap(features[i]);
            hash[i] = MurmurHash2.hash64(buffer, 0, features[i].length, 0L);
        }
        return weight -> {
            if (((int[])weight).length != n) {
                throw new IllegalArgumentException("Invalid weight vector size");
            }
            int BITS = 64;
            int[] count = new int[n];
            for (int i = 0; i < n; ++i) {
                long h = hash[i];
                int w = weight[i];
                for (int j = 0; j < 64; ++j) {
                    if ((h >>> i & 1L) == 1L) {
                        int n2 = j;
                        count[n2] = count[n2] + w;
                        continue;
                    }
                    int n3 = j;
                    count[n3] = count[n3] - w;
                }
            }
            long bits = 0L;
            long one = 1L;
            for (int i = 0; i < 64; ++i) {
                if (count[i] >= 0) {
                    bits |= one;
                }
                one <<= 1;
            }
            return bits;
        };
    }

    public static SimHash<String[]> text() {
        return tokens -> {
            int BITS = 64;
            int[] bits = new int[64];
            for (String s : tokens) {
                byte[] bytes = s.getBytes();
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                long hash = MurmurHash2.hash64(buffer, 0, bytes.length, 0L);
                for (int i = 0; i < 64; ++i) {
                    if ((hash >>> i & 1L) == 1L) {
                        int n = i;
                        bits[n] = bits[n] + 1;
                        continue;
                    }
                    int n = i;
                    bits[n] = bits[n] - 1;
                }
            }
            long hash = 0L;
            long one = 1L;
            for (int i = 0; i < 64; ++i) {
                if (bits[i] >= 0) {
                    hash |= one;
                }
                one <<= 1;
            }
            return hash;
        };
    }
}

