/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.nodes;

import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.util.Util;
import com.github.curiousoddman.rgxgen.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;

public class SymbolSet
extends Node {
    private static final int SPACE_ASCII_CODE = 32;
    private static final int DEL_ASCII_CODE = 127;
    private static final Character[] ALL_SYMBOLS = new Character[95];
    private final Collection<Character> aInitial;
    private final Collection<Character> aModification;
    private final TYPE aType;
    private Character[] aSymbols;
    private Character[] aSymbolsCaseInsensitive;

    public static Character[] getAllSymbols() {
        return (Character[])ALL_SYMBOLS.clone();
    }

    public SymbolSet() {
        this(".", (Character[])ALL_SYMBOLS.clone(), TYPE.POSITIVE);
    }

    public SymbolSet(String pattern, Character[] symbols, TYPE type) {
        this(pattern, Collections.emptyList(), symbols, type);
    }

    public SymbolSet(String pattern, Collection<SymbolRange> symbolRanges, TYPE type) {
        this(pattern, symbolRanges, Util.ZERO_LENGTH_CHARACTER_ARRAY, type);
    }

    public SymbolSet(String pattern, Collection<SymbolRange> symbolRanges, Character[] symbols, TYPE type) {
        super(pattern);
        this.aType = type;
        if (this.aType == TYPE.POSITIVE) {
            this.aInitial = new HashSet<Character>(ALL_SYMBOLS.length);
            this.aModification = new ArrayList<Character>(Arrays.asList(symbols));
        } else {
            this.aInitial = new HashSet<Character>(Arrays.asList(ALL_SYMBOLS));
            this.aModification = new HashSet<Character>(Arrays.asList(symbols));
        }
        symbolRanges.stream().map(SymbolSet::rangeToList).forEach(this.aModification::addAll);
    }

    private static Collection<Character> rangeToList(SymbolRange range) {
        ArrayList<Character> chars = new ArrayList<Character>(range.aTo - range.aFrom + 1);
        for (int i = range.aFrom; i <= range.aTo; ++i) {
            chars.add(Character.valueOf((char)i));
        }
        return chars;
    }

    private Character[] getOrInitSymbols() {
        if (this.aSymbols == null) {
            if (this.aType == TYPE.POSITIVE) {
                this.aInitial.addAll(this.aModification);
            } else {
                this.aInitial.removeIf(this.aModification::contains);
            }
            this.aSymbols = this.aInitial.toArray(Util.ZERO_LENGTH_CHARACTER_ARRAY);
        }
        return this.aSymbols;
    }

    private Character[] getOrInitCaseInsensitiveSymbols() {
        if (this.aSymbolsCaseInsensitive == null) {
            HashSet<Character> caseInsensitive = new HashSet<Character>(this.aInitial);
            if (this.aType == TYPE.POSITIVE) {
                SymbolSet.handleCaseSensitiveCharacters(this.aModification, caseInsensitive::add);
            } else {
                SymbolSet.handleCaseSensitiveCharacters(this.aModification, caseInsensitive::remove);
            }
            this.aSymbolsCaseInsensitive = caseInsensitive.toArray(Util.ZERO_LENGTH_CHARACTER_ARRAY);
        }
        return this.aSymbolsCaseInsensitive;
    }

    private static void handleCaseSensitiveCharacters(Iterable<Character> symbols, Consumer<Character> consumer) {
        for (Character c : symbols) {
            if (Character.isUpperCase(c.charValue())) {
                consumer.accept(Character.valueOf(Character.toLowerCase(c.charValue())));
            } else if (Character.isLowerCase(c.charValue())) {
                consumer.accept(Character.valueOf(Character.toUpperCase(c.charValue())));
            }
            consumer.accept(c);
        }
    }

    @Override
    public void visit(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public Character[] getSymbols() {
        return this.getOrInitSymbols();
    }

    public Character[] getSymbolsCaseInsensitive() {
        return this.getOrInitCaseInsensitiveSymbols();
    }

    public String toString() {
        return "SymbolSet{" + Arrays.toString((Object[])this.getOrInitSymbols()) + '}';
    }

    public boolean isEmpty() {
        return this.getOrInitSymbols().length == 0;
    }

    static {
        for (int i = 32; i < 127; ++i) {
            SymbolSet.ALL_SYMBOLS[i - 32] = Character.valueOf((char)i);
        }
    }

    public static class SymbolRange {
        public static final SymbolRange SMALL_LETTERS = new SymbolRange('a', 'z');
        public static final SymbolRange CAPITAL_LETTERS = new SymbolRange('A', 'Z');
        public static final SymbolRange DIGITS = new SymbolRange('0', '9');
        private final int aFrom;
        private final int aTo;

        public SymbolRange(char from, char to) {
            this.aFrom = from;
            this.aTo = to;
        }
    }

    public static enum TYPE {
        POSITIVE,
        NEGATIVE;

    }
}

