/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.DeliveredRequestedArticles;
import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.RequestedArticles;
import com.franciaflex.magalie.persistence.dao.DeliveredRequestedArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.DeliveredRequestedListJpaDao;
import com.franciaflex.magalie.persistence.dao.RequestedArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.RequestedListJpaDao;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.DeliveredRequestedArticle;
import com.franciaflex.magalie.persistence.entity.DeliveredRequestedList;
import com.franciaflex.magalie.persistence.entity.DeliveredRequestedListStatus;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.RequestedArticle;
import com.franciaflex.magalie.persistence.entity.RequestedList;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.MagalieUserNotificationContext;
import com.franciaflex.magalie.services.StorageMovementConfirmation;
import com.franciaflex.magalie.services.service.ArticleStorageService;
import com.franciaflex.magalie.services.service.FindOrderToExecuteResult;
import com.franciaflex.magalie.services.service.RealTimeStorageMovementTask;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class RequestedArticleService
implements MagalieService {
    private static final Log log = LogFactory.getLog(RequestedArticleService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public FindOrderToExecuteResult findOrderToExecute(MagalieUser magalieUser, Building building, String listType) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        MagalieUserNotificationContext userNotificationContext = this.serviceContext.getUserNotificationContext();
        FindOrderToExecuteResult findOrderToExecuteResult = null;
        DeliveredRequestedListJpaDao deliveredRequestedListDao = persistenceContext.getDeliveredRequestedListDao();
        DeliveredRequestedList affectedDeliveredRequestedList = deliveredRequestedListDao.findByAffectedTo(magalieUser);
        if (affectedDeliveredRequestedList == null) {
            RequestedArticleJpaDao requestedArticleDao = persistenceContext.getRequestedArticleDao();
            List allUndelivered = requestedArticleDao.findAllUndelivered(building, listType);
            if (log.isInfoEnabled()) {
                log.info((Object)(allUndelivered.size() + " undelivered requested articles in building " + building + " for list type " + listType));
            }
            if (allUndelivered.isEmpty()) {
                findOrderToExecuteResult = new FindOrderToExecuteResult();
                findOrderToExecuteResult.setNothingToDo(true);
            } else {
                TreeSet allUndeliveredByPriority = Sets.newTreeSet((Comparator)RequestedArticles.comparator());
                allUndeliveredByPriority.addAll(allUndelivered);
                findOrderToExecuteResult = this.findOrderToExecute(allUndeliveredByPriority, magalieUser, building);
                if (findOrderToExecuteResult != null && findOrderToExecuteResult.isSuccess()) {
                    RequestedList requestedList = findOrderToExecuteResult.getRequestedArticle().getRequestedList();
                    DeliveredRequestedList newAffectation = deliveredRequestedListDao.findByRequestedList(requestedList);
                    if (newAffectation == null) {
                        newAffectation = new DeliveredRequestedList();
                        deliveredRequestedListDao.persist((JpaEntity)newAffectation);
                    } else {
                        Preconditions.checkState((boolean)newAffectation.getStatus().isPending(), (Object)"liste d\u00e9j\u00e0 affect\u00e9e");
                    }
                    newAffectation.setAffectedTo(magalieUser);
                    newAffectation.setRequestedList(requestedList);
                    newAffectation.setStatus(DeliveredRequestedListStatus.AFFECTED);
                    deliveredRequestedListDao.merge((JpaEntity)newAffectation);
                    userNotificationContext.notifyAffectedRequestedList(magalieUser, newAffectation);
                    findOrderToExecuteResult.setNewAffectation(newAffectation);
                }
            }
        } else {
            RequestedList affectedRequestedList = affectedDeliveredRequestedList.getRequestedList();
            findOrderToExecuteResult = this.findOrderToExecute(affectedRequestedList, magalieUser, building);
            if (findOrderToExecuteResult.isSuccess()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("order to execute " + findOrderToExecuteResult + " found in affected list " + affectedDeliveredRequestedList));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("request list " + affectedDeliveredRequestedList.getRequestedList() + " is not complete, putting it back to pending"));
                }
                affectedDeliveredRequestedList.setStatus(DeliveredRequestedListStatus.PENDING);
                affectedDeliveredRequestedList.setAffectedTo(null);
                DeliveredRequestedList oldAffectation = affectedDeliveredRequestedList;
                if (findOrderToExecuteResult.isDriverLicenseRequired()) {
                    userNotificationContext.notifyUnaffectedRequestedListDriverLicenseRequired(magalieUser, oldAffectation);
                } else if (findOrderToExecuteResult.isEverythingUnavailable()) {
                    userNotificationContext.notifyUnaffectedRequestedListForEverythingUnavailable(magalieUser, oldAffectation);
                }
                findOrderToExecuteResult.setOldAffectation(oldAffectation);
            }
        }
        persistenceContext.commit();
        if (log.isInfoEnabled()) {
            log.info((Object)("will return " + findOrderToExecuteResult));
        }
        Preconditions.checkState((findOrderToExecuteResult != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)BooleanUtils.xor((boolean[])Booleans.toArray((Collection)ImmutableSet.of((Object)findOrderToExecuteResult.isSuccess(), (Object)findOrderToExecuteResult.isEverythingUnavailable(), (Object)findOrderToExecuteResult.isNothingToDo(), (Object)findOrderToExecuteResult.isDriverLicenseRequired()))));
        return findOrderToExecuteResult;
    }

    protected FindOrderToExecuteResult findOrderToExecute(RequestedList requestedList, MagalieUser magalieUser, Building building) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        RequestedArticleJpaDao requestedArticleDao = persistenceContext.getRequestedArticleDao();
        List allUndelivered = requestedArticleDao.findAllUndelivered(requestedList);
        Comparator priorityComparator = RequestedArticles.priorityComparator();
        TreeSet requestedArticlesByPriority = Sets.newTreeSet((Comparator)priorityComparator);
        requestedArticlesByPriority.addAll(allUndelivered);
        return this.findOrderToExecute(requestedArticlesByPriority, magalieUser, building);
    }

    protected FindOrderToExecuteResult findOrderToExecute(Set<RequestedArticle> requestedArticlesByPriority, MagalieUser magalieUser, Building building) {
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        RequestedArticle requestedArticle = null;
        boolean success = false;
        Iterator<RequestedArticle> requestedArticleIterator = requestedArticlesByPriority.iterator();
        boolean driverLicenseRequired = false;
        boolean somethingIsAvailable = false;
        while (!success && requestedArticleIterator.hasNext()) {
            boolean articleIsAvailable;
            requestedArticle = requestedArticleIterator.next();
            String articleId = requestedArticle.getArticle().getId();
            RealTimeStorageMovementTask realTimeStorageMovementTask = articleStorageService.getRealTimeStorageMovementTask(building, magalieUser, articleId);
            boolean bl = articleIsAvailable = !realTimeStorageMovementTask.isArticleUnavailable();
            if (articleIsAvailable) {
                somethingIsAvailable = true;
                driverLicenseRequired |= realTimeStorageMovementTask.isDriverLicenseRequired();
            }
            success = articleIsAvailable;
        }
        FindOrderToExecuteResult findOrderToExecuteResult = new FindOrderToExecuteResult();
        if (success) {
            if (log.isInfoEnabled()) {
                log.info((Object)("order to execute found: " + requestedArticle));
            }
            Preconditions.checkState((requestedArticle != null ? 1 : 0) != 0);
            findOrderToExecuteResult.setRequestedArticle(requestedArticle);
        } else if (requestedArticlesByPriority.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"no order to execute found: nothing to do");
            }
            findOrderToExecuteResult.setNothingToDo(true);
        } else if (somethingIsAvailable) {
            if (log.isInfoEnabled()) {
                log.info((Object)"no order to execute found: there is something available to do but driver license is required");
            }
            Preconditions.checkState((boolean)driverLicenseRequired);
            findOrderToExecuteResult.setDriverLicenseRequired(driverLicenseRequired);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"no order to execute found: everything is unavailable");
            }
            Preconditions.checkState((!driverLicenseRequired ? 1 : 0) != 0);
            findOrderToExecuteResult.setEverythingUnavailable(true);
        }
        return findOrderToExecuteResult;
    }

    public List<DeliveredRequestedList> getAllDeliveredRequestedLists() {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        DeliveredRequestedListJpaDao dao = persistenceContext.getDeliveredRequestedListDao();
        List all = dao.findAll();
        return all;
    }

    public void onStorageMovementConfirmation(MagalieUser magalieUser, StorageMovementConfirmation confirmation, Collection<StorageMovement> storageMovements) {
        String requestedArticleId = confirmation.getRequestedArticleId();
        if (requestedArticleId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("confirmation " + confirmation + " doesn't concerns"));
            }
        } else {
            boolean allIsConfirmed;
            if (log.isDebugEnabled()) {
                log.debug((Object)("will confirm article delivery with confirmation " + confirmation));
            }
            JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
            RequestedArticleJpaDao requestedArticleDao = persistenceContext.getRequestedArticleDao();
            RequestedArticle requestedArticle = (RequestedArticle)requestedArticleDao.findById(requestedArticleId);
            DeliveredRequestedArticle newDeliveredRequestedArticle = new DeliveredRequestedArticle();
            newDeliveredRequestedArticle.setRequestedArticle(requestedArticle);
            newDeliveredRequestedArticle.addAllStorageMovements(storageMovements);
            DeliveredRequestedArticleJpaDao deliveredRequestedArticleDao = persistenceContext.getDeliveredRequestedArticleDao();
            deliveredRequestedArticleDao.persist((JpaEntity)newDeliveredRequestedArticle);
            RequestedList requestedList = requestedArticle.getRequestedList();
            List allRequestedArticlesForList = requestedArticleDao.findAllByRequestedList(requestedList);
            List deliveredRequestedArticlesForList = deliveredRequestedArticleDao.findAll(requestedList);
            boolean bl = allIsConfirmed = deliveredRequestedArticlesForList.size() == allRequestedArticlesForList.size() && Iterables.all((Iterable)deliveredRequestedArticlesForList, (Predicate)DeliveredRequestedArticles.isConfirmedPredicate());
            if (allIsConfirmed) {
                DeliveredRequestedListJpaDao deliveredRequestedListDao = persistenceContext.getDeliveredRequestedListDao();
                DeliveredRequestedList deliveredRequestedList = deliveredRequestedListDao.findByRequestedList(requestedList);
                Preconditions.checkNotNull((Object)deliveredRequestedList);
                if (log.isInfoEnabled()) {
                    log.info((Object)("all requested articles have confirmed order, marking list " + requestedList.getCode() + " as complete"));
                }
                MagalieUserNotificationContext userNotificationContext = this.serviceContext.getUserNotificationContext();
                userNotificationContext.notifyUnaffectedRequestedListForCompletedRequestedList(magalieUser, deliveredRequestedList);
                deliveredRequestedList.setStatus(DeliveredRequestedListStatus.COMPLETE);
            }
            persistenceContext.commit();
        }
    }

    public void removeAffectation(MagalieUser magalieUser) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        DeliveredRequestedListJpaDao dao = persistenceContext.getDeliveredRequestedListDao();
        DeliveredRequestedList deliveredRequestedList = dao.findByAffectedTo(magalieUser);
        if (deliveredRequestedList != null && deliveredRequestedList.getStatus().isAffected()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("user " + magalieUser.getLogin() + " is no longer affected to list " + deliveredRequestedList.getRequestedList().getCode()));
            }
            deliveredRequestedList.setAffectedTo(null);
            deliveredRequestedList.setStatus(DeliveredRequestedListStatus.PENDING);
            persistenceContext.commit();
        }
    }

    public Optional<RequestedList> getAffectationForUser(MagalieUser magalieUser) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        DeliveredRequestedListJpaDao dao = persistenceContext.getDeliveredRequestedListDao();
        DeliveredRequestedList deliveredRequestedList = dao.findByAffectedTo(magalieUser);
        Optional affectationForUser = deliveredRequestedList == null ? Optional.absent() : Optional.of((Object)deliveredRequestedList.getRequestedList());
        return affectationForUser;
    }

    public List<String> getListTypes(Building building) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        RequestedListJpaDao dao = persistenceContext.getRequestedListDao();
        List allDistinctListTypes = dao.findAllDistinctListTypes(building);
        return allDistinctListTypes;
    }

    public Optional<DeliveredRequestedList> getDeliveredRequestedList(StorageMovementConfirmation confirmation) {
        String requestedArticleId = confirmation.getRequestedArticleId();
        if (requestedArticleId != null) {
            JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
            RequestedArticleJpaDao requestedArticleDao = persistenceContext.getRequestedArticleDao();
            RequestedArticle requestedArticle = (RequestedArticle)requestedArticleDao.findById(requestedArticleId);
            RequestedList requestedList = requestedArticle.getRequestedList();
            DeliveredRequestedListJpaDao deliveredRequestedListDao = persistenceContext.getDeliveredRequestedListDao();
            DeliveredRequestedList deliveredRequestedList = deliveredRequestedListDao.findByRequestedList(requestedList);
            return Optional.of((Object)deliveredRequestedList);
        }
        Optional result = Optional.absent();
        return result;
    }

    public RequestedArticle getRequestedArticle(String requestedArticleId) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        RequestedArticleJpaDao requestedArticleDao = persistenceContext.getRequestedArticleDao();
        RequestedArticle requestedArticle = (RequestedArticle)requestedArticleDao.findById(requestedArticleId);
        Preconditions.checkNotNull((Object)requestedArticle, (Object)("unable to find requestedArticle with id = " + requestedArticleId));
        return requestedArticle;
    }
}

