/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.StoredArticles;
import com.franciaflex.magalie.persistence.dao.ArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.LocationJpaDao;
import com.franciaflex.magalie.persistence.dao.PreparedArticleReceptionJpaDao;
import com.franciaflex.magalie.persistence.dao.ReceivedPreparedArticleReceptionJpaDao;
import com.franciaflex.magalie.persistence.dao.StorageMovementJpaDao;
import com.franciaflex.magalie.persistence.dao.StoredArticleJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.PreparedArticleReception;
import com.franciaflex.magalie.persistence.entity.ReceivedPreparedArticleReception;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.persistence.entity.Supplier;
import com.franciaflex.magalie.persistence.entity.Warehouse;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.exception.InvalidMagalieBarcodeException;
import com.franciaflex.magalie.services.exception.PreparedArticleReceptionAlreadyStoredException;
import com.franciaflex.magalie.services.service.ArticleStorageService;
import com.franciaflex.magalie.services.service.LocationErrorsService;
import com.franciaflex.magalie.services.service.MagalieBarcodeService;
import com.franciaflex.magalie.services.service.ReceptionConfirmation;
import com.franciaflex.magalie.services.service.ReceptionLocation;
import com.franciaflex.magalie.services.service.ReceptionTask;
import com.franciaflex.magalie.services.service.SuppliersToReceive;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class ReceptionService
implements MagalieService {
    private static final Log log = LogFactory.getLog(ReceptionService.class);
    protected static final boolean LIMIT_EXTRA_LOCATIONS_TO_50 = true;
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public SuppliersToReceive getReceivedSuppliers(Building building) {
        Set<StoredArticle> allReceivedArticles = this.getReceivedArticles(building, null);
        HashSet suppliers = Sets.newHashSet((Iterable)Iterables.transform(allReceivedArticles, (Function)StoredArticles.getArticleSupplierFunction()));
        SuppliersToReceive suppliersToReceive = new SuppliersToReceive(suppliers);
        return suppliersToReceive;
    }

    public Set<StoredArticle> getReceivedArticles(Building building, String supplierId) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        Iterable<Object> receivedArticles = supplierId == null ? storedArticleDao.findAllReceivedForAllSupplier(building) : storedArticleDao.findAllReceivedForSupplier(building, supplierId);
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        List allStorageMovementsInReception = storageMovementDao.findAllInReception(building);
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        receivedArticles = articleStorageService.computeActualQuantities(receivedArticles, allStorageMovementsInReception);
        TreeSet storedArticlesByPriority = Sets.newTreeSet((Comparator)StoredArticles.receptionPriorityComparator());
        Iterables.addAll((Collection)storedArticlesByPriority, (Iterable)receivedArticles);
        if (log.isTraceEnabled()) {
            log.trace((Object)(storedArticlesByPriority.size() + " stored articles found in reception for building " + building + " and supplierId " + supplierId + ": " + storedArticlesByPriority));
        }
        return storedArticlesByPriority;
    }

    public ReceptionTask getReceptionTask(String storedArticleId) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        StoredArticle storedArticle = storedArticleDao.findDetachedById(storedArticleId);
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        List allStorageMovementsImpactingStoredArticle = storageMovementDao.findAllImpactingStoredArticle(storedArticle);
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        Iterable<Object> storedArticleSingleton = Lists.newArrayList((Object[])new StoredArticle[]{storedArticle});
        storedArticleSingleton = articleStorageService.computeActualQuantities(storedArticleSingleton, allStorageMovementsImpactingStoredArticle);
        double quantity = ((StoredArticle)Iterables.getOnlyElement((Iterable)storedArticleSingleton)).getQuantity();
        ReceptionTask receptionTask = this.buildReceptionTask(storedArticle, quantity);
        if (log.isInfoEnabled()) {
            log.info((Object)("reception task is " + receptionTask));
        }
        return receptionTask;
    }

    protected ReceptionTask buildReceptionTask(StoredArticle storedArticle, double quantity) {
        Article article = storedArticle.getArticle();
        Warehouse warehouse = storedArticle.getLocation().getWarehouse();
        if (log.isTraceEnabled()) {
            log.trace((Object)("looking for locations to receive for " + article + " in " + warehouse));
        }
        LocationErrorsService locationErrorsService = this.serviceContext.newService(LocationErrorsService.class);
        Predicate isAcceptableForReception = Predicates.and((Iterable)ImmutableSet.of((Object)Locations.isNotReceptionLocation(), (Object)Locations.isNotFullLocation(), locationErrorsService.getLocationNotReportedInErrorPredicate(article)));
        ReceptionTask receptionTask = new ReceptionTask(storedArticle, quantity);
        Set fixedLocations = article.getFixedLocationsInBuilding(warehouse.getBuilding());
        Iterable acceptableFixedLocations = Iterables.filter((Iterable)fixedLocations, (Predicate)isAcceptableForReception);
        receptionTask.setFixedLocations(acceptableFixedLocations);
        Set<StoredArticle> alreadyUsedLocations = this.getAlreadyUsedLocations(warehouse, article);
        Iterable acceptableAlreadyUsedLocations = Iterables.filter(alreadyUsedLocations, (Predicate)Predicates.compose((Predicate)isAcceptableForReception, (Function)StoredArticles.getLocationFunction()));
        receptionTask.setAlreadyUsedLocations(acceptableAlreadyUsedLocations);
        Set<Location> extraLocations = this.getExtraLocations(warehouse);
        Iterable acceptableExtraLocations = Iterables.filter(extraLocations, (Predicate)isAcceptableForReception);
        receptionTask.setExtraLocations(acceptableExtraLocations);
        if (log.isDebugEnabled()) {
            log.debug((Object)("locations to receive articles for article " + article + " in warehouse " + warehouse + " are acceptable = " + StringUtils.join((Iterable)acceptableAlreadyUsedLocations, (String)", ") + " extra = " + StringUtils.join((Iterable)acceptableExtraLocations, (String)", ")));
        }
        return receptionTask;
    }

    protected Set<Location> getExtraLocations(Warehouse warehouse) {
        LinkedHashSet locations = Sets.newLinkedHashSet();
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        locations.addAll(locationDao.findAllWithoutReception(warehouse, true));
        return locations;
    }

    protected Set<StoredArticle> getAlreadyUsedLocations(Warehouse warehouse, Article article) {
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        Iterable<StoredArticle> storedArticles = articleStorageService.getStoredArticles(warehouse.getBuilding(), article);
        Ordering comparator = Ordering.compound((Iterable)Lists.newArrayList((Object[])new Comparator[]{StoredArticles.locationWithHighestQuantityFirst()}));
        TreeSet sortedStoredArticles = Sets.newTreeSet((Comparator)comparator);
        Iterables.addAll((Collection)sortedStoredArticles, storedArticles);
        return sortedStoredArticles;
    }

    public ReceptionTask getReceptionTaskForPreparedArticleReception(Building building, String barcode) throws PreparedArticleReceptionAlreadyStoredException, InvalidMagalieBarcodeException {
        PreparedArticleReception preparedArticleReception = this.getPreparedArticleReception(building, barcode);
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        Article article = preparedArticleReception.getArticle();
        StoredArticle storedArticle = storedArticleDao.findInReception(building, article);
        ReceptionTask receptionTask = this.buildReceptionTask(storedArticle, preparedArticleReception.getQuantity());
        if (log.isInfoEnabled()) {
            log.info((Object)("reception task for prepared article reception '" + barcode + "' is " + receptionTask));
        }
        return receptionTask;
    }

    public void confirmReception(MagalieUser magalieUser, ReceptionConfirmation receptionConfirmation, String preparedArticleReceptionBarcode) {
        String storedArticleId = receptionConfirmation.getStoredArticleId();
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        StoredArticle storedArticle = (StoredArticle)storedArticleDao.findById(storedArticleId);
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        Date now = this.serviceContext.getNow();
        HashSet storageMovements = Sets.newHashSet();
        for (Map.Entry<String, Double> locationToStoredQuantity : receptionConfirmation.getLocationIdToStoredQuantities().entrySet()) {
            StorageMovement storageMovement = new StorageMovement();
            Location originLocation = storedArticle.getLocation();
            storageMovement.setOriginLocation(originLocation);
            Location destinationLocation = (Location)locationDao.findById(locationToStoredQuantity.getKey());
            storageMovement.setDestinationLocation(destinationLocation);
            storageMovement.setMagalieUser(magalieUser);
            storageMovement.setArticle(storedArticle.getArticle());
            storageMovement.setActualQuantity(locationToStoredQuantity.getValue());
            storageMovement.setMovementDate(now);
            storageMovement.setConfirmDate(now);
            if (log.isWarnEnabled() && destinationLocation.isFullLocation()) {
                log.warn((Object)("stored article in full destination location, should never occur " + storageMovement));
            }
            storageMovementDao.persist((JpaEntity)storageMovement);
            storageMovements.add(storageMovement);
        }
        if (preparedArticleReceptionBarcode != null) {
            PreparedArticleReceptionJpaDao preparedArticleReceptionDao = persistenceContext.getPreparedArticleReceptionDao();
            PreparedArticleReception preparedArticleReception = preparedArticleReceptionDao.findByBarcode(preparedArticleReceptionBarcode);
            ReceivedPreparedArticleReception newReceivedPreparedArticleReception = new ReceivedPreparedArticleReception();
            newReceivedPreparedArticleReception.setPreparedArticleReception(preparedArticleReception);
            newReceivedPreparedArticleReception.setStorageMovements((Set)storageMovements);
            ReceivedPreparedArticleReceptionJpaDao receivedPreparedArticleReceptionDao = persistenceContext.getReceivedPreparedArticleReceptionDao();
            receivedPreparedArticleReceptionDao.persist((JpaEntity)newReceivedPreparedArticleReception);
        }
        persistenceContext.commit();
    }

    public PreparedArticleReception getPreparedArticleReception(Building building, String barcode) throws InvalidMagalieBarcodeException, PreparedArticleReceptionAlreadyStoredException {
        MagalieBarcodeService magalieBarcodeService = this.serviceContext.newService(MagalieBarcodeService.class);
        PreparedArticleReception preparedArticleReception = magalieBarcodeService.getPreparedArticleReception(building, barcode);
        return preparedArticleReception;
    }

    public ReceptionLocation getReceptionLocation(Building building, MagalieUser magalieUser, String locationBarcode, String articleId) throws InvalidMagalieBarcodeException {
        ArticleJpaDao articleDao = this.serviceContext.getPersistenceContext().getArticleDao();
        Article article = (Article)articleDao.findById(articleId);
        MagalieBarcodeService magalieBarcodeService = this.serviceContext.newService(MagalieBarcodeService.class);
        Location location = magalieBarcodeService.getLocation(locationBarcode, building);
        if (location.isFullLocation()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(magalieUser + " scanned barcode " + locationBarcode + " for reception but location " + location + " is full, reporting error"));
            }
            LocationErrorsService locationErrorsService = this.serviceContext.newService(LocationErrorsService.class);
            locationErrorsService.reportError(location, article, magalieUser);
        }
        ReceptionLocation receptionLocation = new ReceptionLocation(location);
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        Iterable<StoredArticle> storedArticles = articleStorageService.getStoredArticles(building, article);
        ImmutableMap storedArticlesByLocation = Maps.uniqueIndex(storedArticles, (Function)StoredArticles.getLocationFunction());
        StoredArticle storedArticle = (StoredArticle)storedArticlesByLocation.get((Object)location);
        if (storedArticle == null) {
            receptionLocation.setAlreadyStoredQuantity(0.0);
        } else {
            receptionLocation.setAlreadyStoredQuantity(storedArticle.getQuantity());
        }
        return receptionLocation;
    }

    public Optional<Supplier> isSupplierHaveOtherArticlesToReceive(Building building, String storedArticleId) {
        SuppliersToReceive receivedSuppliers;
        boolean isSupplierHaveOtherArticlesToReceive;
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        StoredArticle storedArticle = (StoredArticle)storedArticleDao.findById(storedArticleId);
        Supplier supplier = storedArticle.getArticle().getSupplier();
        Optional result = supplier == null ? Optional.absent() : ((isSupplierHaveOtherArticlesToReceive = (receivedSuppliers = this.getReceivedSuppliers(building)).getSuppliersByGroup().values().contains((Object)supplier)) ? Optional.of((Object)supplier) : Optional.absent());
        return result;
    }
}

