/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.dao.MagalieUserJpaDao;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.google.common.base.Preconditions;
import java.util.List;

public class MagalieUsersService
implements MagalieService {
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public MagalieUser getMagalieUser(String magalieUserId) {
        MagalieUserJpaDao dao = this.serviceContext.getPersistenceContext().getMagalieUserDao();
        MagalieUser magalieUser = (MagalieUser)dao.findById(magalieUserId);
        Preconditions.checkArgument((magalieUser != null ? 1 : 0) != 0, (Object)("there is no user with id '" + magalieUserId + "'"));
        return magalieUser;
    }

    public List<MagalieUser> getAllMagalieUsers() {
        MagalieUserJpaDao dao = this.serviceContext.getPersistenceContext().getMagalieUserDao();
        List allMagalieUsers = dao.findAll();
        return allMagalieUsers;
    }

    public List<MagalieUser> getAllMagalieUsersByCompany(Company company) {
        MagalieUserJpaDao dao = this.serviceContext.getPersistenceContext().getMagalieUserDao();
        List allMagalieUsers = dao.findAllByCompany(company);
        return allMagalieUsers;
    }
}

